% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{vertices.inla.mesh}
\alias{vertices.inla.mesh}
\title{Extract vertex locations from an \code{inla.mesh}}
\usage{
vertices.inla.mesh(object)
}
\arguments{
\item{object}{An \code{inla.mesh} object.}
}
\value{
A SpatialPointsDataFrame of mesh vertex locations. The \code{vrt} column indicates the internal vertex id.
}
\description{
Converts the vertices of an \code{inla.mesh} object into a \code{SpatialPointsDataFrame}.
}
\examples{
\donttest{
data("mrsea")
vrt <- vertices(mrsea$mesh)
ggplot() +
  gg(mrsea$mesh) +
  gg(vrt, color = "red")
}

}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com}
}
