% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_injbarplot.R
\name{gg_injbarplot}
\alias{gg_injbarplot}
\title{Plot player's injury incidence/burden ranking}
\usage{
gg_injbarplot(injds, type = c("incidence", "burden"), title = NULL)
}
\arguments{
\item{injds}{\code{injds} \strong{S3} object (see
\code{\link[=injsummary]{injsummary()}}).}

\item{type}{A character value indicating whether to plot injury incidence's
or injury burden's ranking. One of "incidence" or "burden",
respectively.}

\item{title}{Text for the main title.}
}
\value{
A ggplot object (to which optionally more layers can be added).
}
\description{
A bar chart that shows player-wise injury summary statistics, either injury
incidence or injury burden, ranked in descending order.
}
\examples{
\donttest{
df_exposures <- prepare_exp(raw_df_exposures, player = "player_name",
                            date = "year", time_expo = "minutes_played")
df_injuries  <- prepare_inj(raw_df_injuries, player = "player_name",
                            date_injured = "from", date_recovered = "until")
injd         <- prepare_all(data_exposures = df_exposures,
                            data_injuries  = df_injuries,
                            exp_unit = "matches_minutes")
}

injds <- injsummary(injd)

p1 <- gg_injbarplot(injds, type = "incidence",
                    title = "Overall injury incidence per player")
p2 <- gg_injbarplot(injds, type = "burden",
                    title = "Overall injury burden per player")

# install.packages("gridExtra")
# library(gridExtra)
if (require("gridExtra")) {
  gridExtra::grid.arrange(p1, p2, nrow = 1)
}
}
