% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploreInformWeight.R
\name{sigmaManyToOne}
\alias{sigmaManyToOne}
\title{Calculation of the Covariance Matrix for a Many-to-one-Comparison}
\usage{
sigmaManyToOne(sampleSizes, sampleSizeControl, varObs, checkInput = TRUE)
}
\arguments{
\item{sampleSizes}{A numeric vector indicating the sample size of each
non-control group.}

\item{sampleSizeControl}{A numeric indicating the sample size of the control
group.}

\item{varObs}{A positive numeric indicating the variance of the individual
observations.}

\item{checkInput}{A boolean specifying whether the entered values should be
checked.}
}
\value{
Returns covariance matrix.
}
\description{
The function calculates the covariance matrix for many-to-one-comparisons.
The covariance matrix is calculated for the point estimators,
each defined by the difference between the empirical mean of one of
the experimental groups and the empirical mean of the control group.
}
\examples{
sigmaManyToOne(sampleSizes=c(89,95), sampleSizeControl=77,
 varObs=10)
}
