% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{clusterRank}
\alias{clusterRank}
\alias{CR}
\title{ClusterRank (CR)}
\usage{
clusterRank(graph, vids = V(graph), directed = FALSE, loops = TRUE)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{directed}{Logical scalar, whether to directed graph is analyzed. This argument is ignored for undirected graphs.}

\item{loops}{Logical; whether the loop edges are also counted.}
}
\value{
A numeric vector contaning the ClusterRank centrality scores for the selected vertices.
}
\description{
This function calculates the ClusterRank of input vertices and
works with both directed and undirected networks.
This function and all of its descriptions have been adapted from the centiserve package with
some minor modifications. ClusterRank is a local ranking algorithm which takes into account not only
the number of neighbors and the neighbors’ influences, but also the clustering coefficient.
}
\examples{
MyData <- coexpression.data
My_graph <- graph_from_data_frame(MyData)
GraphVertices <- V(My_graph)
cr <- clusterRank(graph = My_graph, vids = GraphVertices, directed = FALSE, loops = TRUE)
}
\seealso{
Other centrality functions: 
\code{\link{betweenness}()},
\code{\link{collective.influence}()},
\code{\link{degree}()},
\code{\link{h_index}()},
\code{\link{lh_index}()},
\code{\link{neighborhood.connectivity}()}
}
\concept{centrality functions}
\keyword{clusterRank}
