% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check.parameters}
\alias{check.parameters}
\title{Check input parameters}
\usage{
check.parameters(
  matrix,
  penalty,
  algorithm,
  cross_validation,
  seed,
  n_folds,
  k_folds,
  r_threshold,
  regulators,
  targets,
  regulators_num,
  verbose,
  cores
)
}
\arguments{
\item{matrix}{An expression matrix, cells by genes}

\item{penalty}{The type of regularization.
This can take either one of the following choices: "L0" and "L0L2".
For high-dimensional and sparse data, such as single-cell sequencing data, "L0L2" is more effective.}

\item{algorithm}{The type of algorithm used to minimize the objective function.
Currently "CD" and "CDPSI" are supported.
The CDPSI algorithm may yield better results, but it also increases running time.}

\item{cross_validation}{Check whether cross validation is used.}

\item{seed}{The seed used in randomly shuffling the data for cross-validation.}

\item{n_folds}{The number of folds for cross-validation.}

\item{k_folds}{The number of folds for sample split.}

\item{r_threshold}{Threshold of R^2.}

\item{regulators}{Regulator genes.}

\item{targets}{Target genes.}

\item{regulators_num}{The number of non-zore coef, this value will affect the final performance.
The maximum support size at which to terminate the regularization path.
Recommend setting this to a small fraction of min(n,p) (e.g. 0.05 * min(n,p)) as L0 regularization typically selects a small portion of non-zeros.}

\item{verbose}{Print detailed information.}

\item{cores}{CPU cores.}
}
\value{
No return value, called for check input parameters
}
\description{
Check input parameters
}
