% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse.regression.R
\name{sub.inferCSN}
\alias{sub.inferCSN}
\title{Sparse regression model for single gene}
\usage{
sub.inferCSN(
  regulators_matrix,
  targets_matrix,
  target = NULL,
  cross_validation = FALSE,
  seed = 1,
  penalty = "L0",
  algorithm = "CD",
  regulators_num = NULL,
  n_folds = 10,
  k_folds = NULL,
  r_threshold = 0,
  verbose = FALSE
)
}
\arguments{
\item{regulators_matrix}{Regulators matrix}

\item{targets_matrix}{Targets matrix}

\item{target}{Target genes}

\item{cross_validation}{Check whether cross validation is used.}

\item{seed}{The seed used in randomly shuffling the data for cross-validation.}

\item{penalty}{The type of regularization.
This can take either one of the following choices: "L0" and "L0L2".
For high-dimensional and sparse data, such as single-cell sequencing data, "L0L2" is more effective.}

\item{algorithm}{The type of algorithm used to minimize the objective function.
Currently "CD" and "CDPSI" are supported.
The CDPSI algorithm may yield better results, but it also increases running time.}

\item{regulators_num}{The number of non-zore coef, this value will affect the final performance.
The maximum support size at which to terminate the regularization path.
Recommend setting this to a small fraction of min(n,p) (e.g. 0.05 * min(n,p)) as L0 regularization typically selects a small portion of non-zeros.}

\item{n_folds}{The number of folds for cross-validation.}

\item{k_folds}{The number of folds for sample split.}

\item{r_threshold}{Threshold of R^2.}

\item{verbose}{Print detailed information.}
}
\value{
The weight data table of sub-network
}
\description{
Sparse regression model for single gene
}
