% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_confidence_interval.R
\name{get_confidence_interval}
\alias{get_confidence_interval}
\alias{get_ci}
\title{Compute confidence interval}
\usage{
get_confidence_interval(
  x,
  level = 0.95,
  type = "percentile",
  point_estimate = NULL
)

get_ci(x, level = 0.95, type = "percentile", point_estimate = NULL)
}
\arguments{
\item{x}{Data frame of calculated statistics or containing attributes of
theoretical distribution values. Currently, dependent on statistics being
stored in \code{stat} column as created in \code{\link[=calculate]{calculate()}} function.}

\item{level}{A numerical value between 0 and 1 giving the confidence level.
Default value is 0.95.}

\item{type}{A string giving which method should be used for creating the
confidence interval. The default is \code{"percentile"} with \code{"se"}
corresponding to (multiplier * standard error) as the other option.}

\item{point_estimate}{A numeric value or a 1x1 data frame set to \code{NULL} by
default. Needed to be provided if \code{type = "se"}.}
}
\value{
A 1 x 2 tibble with values corresponding to lower and upper values in
the confidence interval.
}
\description{
Compute a confidence interval around a summary statistic. Only
simulation-based methods are (currently only) supported.

Learn more in \code{vignette("infer")}.
}
\section{Aliases}{

\code{get_ci()} is an alias of \code{get_confidence_interval()}.
\code{conf_int()} is a deprecated alias of \code{get_confidence_interval()}.
}

\examples{

# find the point estimate---mean number of hours worked per week
point_estimate <- gss \%>\%
  specify(response = hours) \%>\%
  calculate(stat = "mean") \%>\%
  dplyr::pull()

# starting with the gss dataset
gss \%>\%
  # ...we're interested in the number of hours worked per week
  specify(response = hours) \%>\%
  # hypothesizing that the mean is 40
  hypothesize(null = "point", mu = 40) \%>\%
  # generating data points for a null distribution
  generate(reps = 1000, type = "bootstrap") \%>\%
  # finding the null distribution
  calculate(stat = "mean") \%>\%
  get_confidence_interval(point_estimate = point_estimate,
                          # at the 95\% confidence level
                          level = .95,
                          # using the standard error method
                          type = "se")
  
# More in-depth explanation of how to use the infer package
\dontrun{
vignette("infer")
} 
 
}
