% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shade_p_value.R
\name{shade_p_value}
\alias{shade_p_value}
\alias{shade_pvalue}
\title{Add information about p-value region(s)}
\usage{
shade_p_value(obs_stat, direction, color = "red2", fill = "pink", ...)

shade_pvalue(obs_stat, direction, color = "red2", fill = "pink", ...)
}
\arguments{
\item{obs_stat}{A numeric value or 1x1 data frame corresponding to what the
observed statistic is.}

\item{direction}{A string specifying in which direction the shading should
occur. Options are \code{"less"}, \code{"greater"}, or \code{"two_sided"}. Can
also give \code{"left"}, \code{"right"}, or \code{"both"}. If \code{NULL} then no shading is
actually done.}

\item{color}{A character or hex string specifying the color of the observed
statistic as a vertical line on the plot.}

\item{fill}{A character or hex string specifying the color to shade the
p-value region. If \code{NULL} then no shading is actually done.}

\item{...}{Other arguments passed along to \\{ggplot2\\} functions.}
}
\value{
A list of \\{ggplot2\\} objects to be added to the \code{visualize()}
output.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}

\code{shade_p_value()} plots p-value region(s) (using "area under the curve"
approach) on top of the \code{\link[=visualize]{visualize()}} output. It should be used as
\\{ggplot2\\} layer function (see examples). \code{shade_pvalue()} is its alias.

Learn more in \code{vignette("infer")}.
}
\examples{
# find the point estimate---mean number of hours worked per week
point_estimate <- gss \%>\%
  specify(response = hours) \%>\%
  calculate(stat = "mean") \%>\%
  dplyr::pull()
  
# ...and a null distribution
null_dist <- gss \%>\%
  # ...we're interested in the number of hours worked per week
  specify(response = hours) \%>\%
  # hypothesizing that the mean is 40
  hypothesize(null = "point", mu = 40) \%>\%
  # generating data points for a null distribution
  generate(reps = 10000, type = "bootstrap") \%>\%
  # finding the null distribution
  calculate(stat = "mean")
  
# shade the p-value of the point estimate
null_dist \%>\%
  visualize() +
  shade_p_value(obs_stat = point_estimate, direction = "two_sided")

# More in-depth explanation of how to use the infer package
vignette("infer")

}
\seealso{
\code{\link[=shade_confidence_interval]{shade_confidence_interval()}} to add information about confidence
interval.
}
