% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_functions.R
\name{muSigma}
\alias{muSigma}
\title{Function to estimate mean and covariance for unknown parameters 
\eqn{\beta}.}
\usage{
muSigma(Z, X = NULL, fit.method = "KL", wls.method = "default")
}
\arguments{
\item{Z}{list of design points and link function that is an output of 
function \code{designLink}}

\item{X}{model matrix for model formula and design points. The covariates 
must correspond to the description of design points in \code{Z}, but can be
transformed etc. If \code{NULL} then \code{X} will be coerced by applying 
\code{as.matrix()} to \code{Z$design}. The matrix \code{X} should be full 
rank when subsetted to the elicited design points. If a column of \code{X} 
has the name \code{offset} then this column is treated as an offset during 
estimation}

\item{fit.method}{character, \code{moment}, \code{KL}. See \code{mV()}. Default
is \code{KL}.}

\item{wls.method}{character giving the numerical solution method: \code{QR}, 
using the QR decomposition, \code{SVD}, using the singular value 
decomposition, or option \code{default} that uses \code{solve()}}
}
\value{
list of \code{mu}, numeric vector of location parameters for the 
  normal prior; \code{Sigma}, the covariance matrix; and \code{log.like}, a 
  scalar
}
\description{
Function to estimate mean and covariance for unknown parameters 
\eqn{\beta}.
}
\examples{
X <- matrix(c(1, 1, 0, 1), nrow = 2) # design
Z <- designLink(design = X)
Z <- elicitPt(Z, design.pt = 1,
  lower.CI.bound = -1,
  median = 0,
  upper.CI.bound = 1,
  comment = "The first completed elicitation scenario.")
Z <- elicitPt(Z, design.pt = 2,
  lower.CI.bound = -2,
  median = 1,
  upper.CI.bound = 2,
  comment = "The second completed elicitation scenario.")
prior <- muSigma(Z, X, fit.method = "KL")
prior$mu
prior$Sigma   
}
