% Generated by roxygen2 (4.0.2): do not edit by hand
\name{face_emotion}
\alias{face_emotion}
\title{Detects face emotion}
\usage{
face_emotion(img, local.api = FALSE)
}
\arguments{
\item{img}{image data}

\item{local.api}{logical, whether use local or remote API}
}
\value{
List with face emotions probability pairs
}
\description{
Given a grayscale input image of a face, returns a probability distribution over emotional state.
Input should be a two-dimensional strucrure (like data.frame or matrix), resizing will be attempted internally but for best
performance, images should be already sized at 48x48 pixels.
}
\examples{
## Example 1
img <- matrix(runif(48*48, 0, 1), nrow = 48)
emotion <- face_emotion(img)

most.possible <- sort(unlist(emotion), decreasing = TRUE)[1:2]
cat(sprintf("Detected '\%s' emotion with probability \%0.4f.\\n",
            names(most.possible)[1], most.possible[1]))
cat(sprintf("Next possible is '\%s' emotion with probability \%0.4f.",
            names(most.possible)[2], most.possible[2]))

## Example 2
# Reads PNG file
file.face <- system.file("extdata", "face1.png", package = "indicoio")
img <- readPNG(file.face)
# Converts to grayscale
img <- 0.2126 * img[, , 1] + 0.7152 * img[, , 2] + 0.0722 * img[, , 3]
# Plots image
plot(0:1, 0:1, xlab = "", ylab = "", axes = FALSE, col = "white")
rasterImage(img, xleft = 0, ybottom = 0, xright = 1, ytop = 1)
# Detects emotion
face_emotion(img)
}
\seealso{
\code{\link{face_features}}, \code{\link{image_features}}
}
\keyword{API}
\keyword{emotions}
\keyword{face}
\keyword{indico.io}
\keyword{learning}
\keyword{machine}
\keyword{recognition}

