% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.R
\name{prevcounts}
\alias{prevcounts}
\title{Prevalence and Relative Standard Errors by Counts}
\usage{
prevcounts(N, N_H, N_testR, N_R, DE_H = 1, DE_R = 1)
}
\arguments{
\item{N}{Counts of total survey sample size(s) (vector/integer).}

\item{N_H}{Number of HIV positive found in survey(s) (vector/integer).}

\item{N_testR}{Number tested for recency in survey(s) (vector/integer).}

\item{N_R}{Number of recent cases in survey(s) (vector/integer).}

\item{DE_H}{Design effect of HIV prevalence test (vector/numeric), greater than or equal to 1. If multiple surveys are entered but only one design effect is specified, function assumes entered design effect is identical for both surveys.}

\item{DE_R}{Design effect of recency test (vector/numeric), greater than or equal to 1. If multiple surveys are entered but only one design effect is specified, function assumes entered design effect is identical for both surveys.}
}
\value{
Prevalences and relative standard errors. Design effects are assumed negligible unless user specifies otherwise.
}
\description{
Prevalence and Relative Standard Errors by Counts
}
\details{
The package contains long form documentation in the form of vignettes that cover the use of the main fucntions. Use browseVignettes(package="inctools") to access them.
}
\examples{
prevcounts(N = 5000, N_H = 1000, N_testR = 1000, N_R = 70, DE_R = 1.1)

prevcounts (N = c(5000,5000), N_H = c(1000,1000), N_testR = c(1000,1000),
N_R = c(100,70), DE_H = c(1,1.1), DE_R = c(1,1.1))
}
