% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSummaryStatisticsTable.R
\name{computeSummaryStatisticsByRowColVar}
\alias{computeSummaryStatisticsByRowColVar}
\title{Compute summary statistics by specified \code{rowVar} and \code{colVar}}
\usage{
computeSummaryStatisticsByRowColVar(
  data,
  var = NULL,
  varLab = getLabelVar(var = var, data = data, labelVars = labelVars),
  varInclude0 = FALSE,
  varLabInclude = length(var) > 1,
  varTotalInclude = FALSE,
  type = "auto",
  rowVar = NULL,
  rowInclude0 = FALSE,
  rowVarDataLevels = NULL,
  colVar = NULL,
  colInclude0 = FALSE,
  colVarDataLevels = NULL,
  subjectVar = "USUBJID",
  labelVars = NULL,
  statsExtra = NULL,
  msgLabel = NULL,
  checkVarDiffBySubj = "error"
)
}
\arguments{
\item{data}{Data.frame with dataset to consider for the summary table.}

\item{var}{Character vector with variable(s) of \code{data}, 
to compute statistics on.\cr
If NULL (by default), counts by row/column variable(s) are computed.\cr
To also return counts of the \code{rowVar} in case other \code{var}
are specified, you can include: 'all' in the \code{var}.\cr
Missing values, if present, are filtered 
(also for the report of number of subjects/records).}

\item{varLab}{Named character vector with label for each variable 
specified in \code{var}.
By default, extracted from the \code{labelVars}.
if not available, \code{var} is used.}

\item{varInclude0}{Logical, should rows with no counts 
for the count \code{var} or \code{varFlag} variable(s)
be included in the table?
Either:
\itemize{
\item{logical of length 1, if TRUE (FALSE by default) 
rows with no count are included for all \code{var}
}
\item{a character vector containing categorical \code{var} 
for which zero counts rows should be included}
}}

\item{varLabInclude}{Logical, if TRUE
the name of the summary statistic variable(s) (\code{var})
are included in the table.
This is automatically set to TRUE if more than one variable(s) 
and is specified, and FALSE if only one variable is specified.}

\item{varTotalInclude}{Should the total across all categories of \code{var} 
be included for the count table?
Only used for categorical variables (and \code{var} not 'all').
Either:
\itemize{
\item{logical of length 1, if TRUE (FALSE by default) include the total for all categorical \code{var}}
\item{a character vector containing categorical \code{var} for which the total should be included}
}}

\item{type}{String with type of table: 
\itemize{
\item{'summaryTable': summary table with statistics for numeric variable}
\item{'countTable': count table}
\item{'auto' (by default): 'summaryTable' if the variable is numeric,
'countTable' otherwise}
}}

\item{rowVar}{Character vector with variable(s)
to be included in the rows.
If multiple variables are specified, the variables should 
be sorted in hierarchical order
(e.g. body system class before adverse event term)
and are nested in the table.}

\item{rowInclude0}{Logical, if TRUE (FALSE by default),
include rows with no records, based on all combinations 
of the \code{rowVar} (assuming nested variable(s)).}

\item{rowVarDataLevels}{Data.frame with unique combinations of \code{rowVar}
to be included in columns.
Each column should correspond to \code{colVar} and as factor
if the elements should be ordered in the final table.}

\item{colVar}{Character vector with variable(s) to be included in columns.
If multiple variables are specified, the variables should 
be sorted in hierarchical order,
and are included in multi-columns layout.\cr
Use: 'variable' to include the variables to summarize: \code{var}
 (if multiple) in different columns.}

\item{colInclude0}{Logical, if TRUE (FALSE by default),
include columns with no records, based on all combinations 
of the \code{columnVar} (assuming nested variable(s)).
If variable(s) are not nested, possible combinations
can be specified via \code{colVarDataLevels}.}

\item{colVarDataLevels}{Data.frame with unique combinations of \code{colVar}
to be included in columns.
Each column should correspond to \code{colVar} and as factor
if the elements should be ordered in the final table.}

\item{subjectVar}{String, variable of \code{data} with subject ID,
'USUBJID' by default.}

\item{labelVars}{(optional) Named character vector with label for
the row, column variable(s) or variable(s) to summarize. \cr
Labels specified via dedicated parameter: e.g. 
\code{rowVarLab}, \code{colVarLab}, \code{varLab}
have priority on this parameter.}

\item{statsExtra}{(optional) Named list with functions for additional custom
statistics to be computed.\cr
Each function:
\itemize{
\item{has as parameter, either: 'x': the variable (\code{var}) to compute
the summary statistic on or 'data': the entire dataset}
\item{returns the corresponding summary statistic as a numeric vector}
}
For example, to additionally compute the coefficient of variation, this can be set to:
\code{list(statCVPerc = function(x) sd(x)/mean(x)*100)} (or \code{\link{cv}}).}

\item{checkVarDiffBySubj}{String, 'error' (default), 'warning',
or 'none'.  
Should an error, a warning, or nothing be produced
if a continuous variable (\code{var}) contains
different values for the same subject (by row/column)?}
}
\value{
data.frame of class 'countTable' or 'summaryTable',
depending on the 'type' parameter; with statistics in columns,
either if \code{type} is:
\itemize{
\item{'summaryTable': 
\itemize{
\item{'N': number of subjects}
\item{'Mean': mean of \code{var}}
\item{'SD': standard deviation of \code{var}}
\item{'SE': standard error of \code{var}}
\item{'Median': median of \code{var}}
\item{'Min': minimum of \code{var}}
\item{'Max': maximum of \code{var}}
\item{'m': number of records}
}
}
\item{'countTable': 
\itemize{
\item{'N': number of subjects}
\item{'m': number of records}
}
}
}
}
\description{
Compute summary statistics by specified \code{rowVar} and \code{colVar}
}
\author{
Laure Cougnaud
}
\keyword{internal}
