% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_interpolation.R
\name{na_interpolation}
\alias{na_interpolation}
\title{Missing Value Imputation by Interpolation}
\usage{
na_interpolation(x, option = "linear", maxgap = Inf, ...)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}})
object in which missing values shall be replaced}

\item{option}{Algorithm to be used. Accepts the following input:
\itemize{
\item{"linear" - for linear interpolation using \link{approx} } (default choice)
\item{"spline" - for spline interpolation using \link{spline}}
\item{"stine" - for Stineman interpolation using \link[stinepack]{stinterp}}
}}

\item{maxgap}{Maximum number of successive NAs to still perform imputation on.
Default setting is to replace all NAs without restrictions. With this
option set, consecutive NAs runs, that are longer than 'maxgap' will
be left NA. This option mostly makes sense if you want to
treat long runs of NA afterwards separately.}

\item{...}{Additional parameters to be passed through to \link{approx} or
\link{spline} interpolation functions}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}})
object (dependent on given input at parameter x)
}
\description{
Uses either linear, spline or stineman interpolation
to replace missing values.
}
\details{
Missing values get replaced by values of a \link{approx}, \link{spline}
or \link[stinepack]{stinterp} interpolation.
}
\examples{
# Prerequisite: Create Time series with missing values
x <- ts(c(2, 3, 4, 5, 6, NA, 7, 8))

# Example 1: Perform linear interpolation
na_interpolation(x)

# Example 2: Perform spline interpolation
na_interpolation(x, option = "spline")

# Example 3: Perform stine interpolation
na_interpolation(x, option = "stine")

# Example 4: Same as example 1, just written with pipe operator
x \%>\% na_interpolation()

# Example 5: Same as example 2, just written with pipe operator
x \%>\% na_interpolation(option = "spline")
}
\references{
Johannesson, Tomas, et al. (2015). "Package stinepack".
}
\seealso{
\code{\link[imputeTS]{na_kalman}}, \code{\link[imputeTS]{na_locf}},
\code{\link[imputeTS]{na_ma}}, \code{\link[imputeTS]{na_mean}},
\code{\link[imputeTS]{na_random}}, \code{\link[imputeTS]{na_replace}},
\code{\link[imputeTS]{na_seadec}}, \code{\link[imputeTS]{na_seasplit}}
}
\author{
Steffen Moritz
}
