% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.interpolation.R
\name{na.interpolation}
\alias{na.interpolation}
\title{Missing Value Imputation by Interpolation}
\usage{
na.interpolation(x, option = "linear", ...)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object in which missing values shall be replaced}

\item{option}{Algorithm to be used. Accepts the following input:
\itemize{
   \item{"linear" - for linear interpolation using \link{approx} }
   \item{"spline" - for spline interpolation using \link{spline}}
   \item{"stine" - for Stineman interpolation using \link[stinepack]{stinterp}}
   }}

\item{...}{Additional parameters to be passed through to \link{approx} or \link{spline} interpolation functions}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object (dependent on given input at parameter x)
}
\description{
Uses either linear, spline or stineman interpolation to replace missing values.
}
\details{
Missing values get replaced by values of a \link{approx}, \link{spline} or \link[stinepack]{stinterp} interpolation.
}
\examples{
#Prerequisite: Create Time series with missing values
x <- ts(c(2,3,4,5,6,NA,7,8))

#Example 1: Perform linear interpolation
na.interpolation(x)

#Example 2: Perform spline interpolation
na.interpolation(x, option = "spline")

#Example 3: Perform stine interpolation
na.interpolation(x, option = "stine")

#Example 4: Same as example 1, just written with pipe operator
x \%>\% na.interpolation

#Example 5: Same as example 2, just written with pipe operator
x \%>\% na.interpolation(option = "spline")

}
\references{
Johannesson, Tomas, et al. (2015). "Package stinepack".
}
\seealso{
\code{\link[imputeTS]{na.kalman}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.ma}}, \code{\link[imputeTS]{na.mean}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}},
 \code{\link[imputeTS]{na.seadec}}, \code{\link[imputeTS]{na.seasplit}}
}
\author{
Steffen Moritz
}
