% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censo_poblacion_iter.R
\name{censo_poblacion_iter}
\alias{censo_poblacion_iter}
\title{Censo de Poblacion - ITER}
\usage{
censo_poblacion_iter(
  year = "2010",
  estado = "Nacional",
  totalestado = FALSE,
  totalmunicipio = FALSE,
  localidades = TRUE
)
}
\arguments{
\item{year}{Año del levantamiento del censo en formato numerico. Los años disponibles (incluyendo los conteos) son: 1990, 1995, 2000, 2005, 2010 y 2015}

\item{estado}{Define el nombre de la entidad federativa para descargar los datos, en formato alfanumerico. La funcion, por defecto utiliza la palabra "Nacional" para descargar los datos de todos los estados. Los nombres de los estados deben ir capitalizados (y en su caso, con espacios), por ejemplo: "Aguascalientes", "CDMX", "San Luis Potosi".}

\item{totalestado}{Resultados agregados a nivel entidad federativa. \code{FALSE} omite los resultados a nivel entidad federativa.}

\item{totalmunicipio}{Resultados agregados a nivel municipio. \code{FALSE} omite los resultados a nivel municipio.}

\item{localidades}{Si se requiere conservar unicamente los resultados a nivel agregado (estado o municipio), \code{FALSE} eliminara las observaciones por localidad.}
}
\value{
Data.frame
}
\description{
Censo de Poblacion y Vivienda. Principales resultados por localidad (ITER).
}
\details{
Esta base de datos tiene dos niveles de agregacion: entidades federativas y municipios.
}
\examples{

# Consultar los datos ITER del Censo de Poblacion y Vivienda
\dontrun{censo_poblacion_iter()}

# Descargar los datos de CDMX de 2010.
\dontrun{iter = censo_poblacion_iter(year = 2010, estado = "CDMX")}
}
