% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_sciat.R
\name{clean_sciat}
\alias{clean_sciat}
\title{Prepare and clean SC-IAT data}
\usage{
clean_sciat(data, sbj_id = "participant", block_id = "blockcode",
  accuracy_id = "correct", latency_id = "latency",
  block_sciat_1 = NULL, block_sciat_2 = NULL, trial_id = NULL,
  trial_eliminate = NULL, demo_id = NULL, trial_demo = NULL)
}
\arguments{
\item{data}{Dataframe containing SC-IAT data.}

\item{sbj_id}{Column identifying participants' IDs. This variable can be a \code{character},
\code{numeric}, of \code{factor}.}

\item{block_id}{String. Column identifying
SC-IAT blocks. The \code{block_id} variable should be a
\code{factor} with each level identifying a SC-IAT block.}

\item{accuracy_id}{String. Column identifying the
IAT accuracy responses. The \code{accuracy_id} variable
should be a numeric variable identifying the correct
responses (with 1) and the incorrect responses (with 0).}

\item{latency_id}{String. Column identifying
response times (in millisecond).}

\item{block_sciat_1}{Character or character vector. Labels identifying the first SC-IAT
blocks as they are named in the \code{block_id}.}

\item{block_sciat_2}{Character or character vector. Labels identifying the second (if present) SC-IAT
blocks as they are named in the \code{block_id}.}

\item{trial_id}{Character. Column identifying the trials. Specify this only
if you want to delete some specific trials. If a response window was used
for the SC-IAT administration the label of the non-response must be included in
this variable.}

\item{trial_eliminate}{Character or character vector. Labels of the trials to
eliminate in the \code{trial_id} to eliminate (NOTE: don't use this command
to delete the responses exceeding the response time window).}

\item{demo_id}{Character. Character. Column identifying demographic blocks.
It can be the same as \code{block_id}.}

\item{trial_demo}{Character or character vector identifying the name of the
blocks in \code{demo_id} containing the demographic information.}
}
\value{
List of dataframe.

 \describe{
    \item{\code{sciat1}}{Data frame with class \code{sciat_clean} containing
    the data of the first SC-IAT as specified  \code{block_sciat_1}.
    If any labels was specified in \code{trial_eliminate}, \code{data_keep}
    will contain the already cleaned dataset.}
    \item{\code{sciat2}}{Data frame with class \code{sciat_clean} containing
    the data of the second (if any) SC-IAT as specified through \code{block_sciat_2}.
    If any labels was specified in \code{trial_eliminate}, \code{data_keep}
    will contain the already cleaned dataset.}
    \item{\code{data_demo}}{Data frame. Present only when
    \code{variable_demo} and \code{trial_demo} arguments are specified.}
    }
}
\description{
Select the SC-IAT blocks, for either one or two SC-IATs. Eventually
save demographic data.
}
\examples{
data("raw_data")
sciat_data <- clean_sciat(raw_data, sbj_id = "Participant",
                         block_id = "blockcode",
                         latency_id = "latency",
                         accuracy_id = "correct",
                         block_sciat_1 = c("test.sc_dark.Darkbad",
                                           "test.sc_dark.Darkgood"),
                         block_sciat_2 = c("test.sc_milk.Milkbad",
                                           "test.sc_milk.Milkgood"),
                         trial_id  = "trialcode",
                         trial_eliminate = c("reminder",
                                             "reminder1"))
sciat1 <- sciat_data[[1]]
sciat2 <- sciat_data[[2]]
}
