\name{sim.data}
\alias{sim.data}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Simulation of data sets by controlling the proportion of MCAR values and the distribution of MNAR values.
}
\description{
This function simulates data sets similar to MS-based bottom-up proteomic data sets.
}
\usage{
sim.data(nb.pept=2000,nb.miss=600,pi.mcar=0.2,para=10,nb.cond=2,nb.repbio=3,
nb.sample=5,m.c=25,sd.c=2,sd.rb=0.5,sd.r=0.2)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{nb.pept}{The number of rows (identified peptides) of the generated data set.}
  \item{nb.miss}{The number of missing values to generate in each column.}
  \item{pi.mcar}{The proportion of MCAR values in each column.}
  \item{para}{Parameter of a Beta distribution used for simulating MNAR values in columns (see Details).}
  \item{nb.cond}{The number of studied biological conditions.}
  \item{nb.repbio}{The number of biological samples in each condition.}
  \item{nb.sample}{The number of samples coming from each biological sample.}
  \item{m.c}{The mean of the average values in each condition.}
  \item{sd.c}{The standard deviation of the average values in each condition.}
  \item{sd.rb}{The standard deviation of the average values in each biological sample.}
  \item{sd.r}{The standard deviation of values in each row among the samples coming from a same biological sample.}
}
\details{
First, the average of intensities of a peptide \code{i} in a condition is generated by a Gaussian distribution \eqn{m_{cond}\sim N(m.c,sd.c)}. Second, the effect of a biological sample is generated by \eqn{m_{bio}\sim N(0,sd.rb)}. The value of a peptide \code{i} in the sample \code{j} belonging to a specific biological sample and a specific condition is finally generated by \eqn{x_{ij}\sim N(m_{cond}+m_{bio},sd.r)}. 

Next, the MCAR values are generated in each column by random draws without replacement among the indexes of rows. The MNAR values are generated in the remaining indexes of rows by random draws without replacement and by respecting the following probabilities:

\eqn{P(x_{ij} is MNAR)=f_{B(1,para)}((x_{ij}-min_i(x_{ij}))/(max_i(x_{ij})-min_i(x_{ij})))/(para)}

where \eqn{f_{B(1,para)}} corresponds to the density of a Beta distribution with parameters \eqn{1} and \eqn{para}. If \eqn{para=1}, then the MNAR values are uniformly distributed among intensity level. More \eqn{para} is high and more the MNAR values arise for small intensity levels and not for high intensity levels.
}
\value{
\item{dat.obs}{The simulated data set.}
\item{dat.comp}{The simulated data set without missing values.}
\item{list.MCAR}{The index of MCAR values among the rows in each column of the data set.}
\item{conditions}{A vector of factors indicating the biological condition to which each sample belongs.}
\item{repbio}{A vector of factors indicating the biological sample to which each sample belongs.}
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{
Quentin Giai Gianetto <quentin2g@yahoo.fr>
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
\donttest{
## The function is currently defined as
res.sim=sim.data(nb.pept=2000,nb.miss=600,pi.mcar=0.2,para=10,nb.cond=2,nb.repbio=3,
nb.sample=5,m.c=25,sd.c=2,sd.rb=0.5,sd.r=0.2);
## Simulated data matrix
data=res.sim$dat.obs;
## Vector of conditions of membership for each sample
cond=res.sim$conditions;
## Vector of biological sample of membership for each sample
repbio=res.sim$repbio;
}
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{Simulated data}
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
