% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{gridPage}
\alias{gridPage}
\title{Create a page a with CSS grid layout}
\usage{
gridPage(..., title = NULL, fill_page = TRUE, dependency = bootstrapLib())
}
\arguments{
\item{...}{Elements to include within the page}

\item{title}{The browser window title (defaults to the host URL of the page).}

\item{fill_page}{Flag to tell the page if it should adjust the page to
adjust and fill the browser window size.}

\item{dependency}{The set of web dependencies. This value can be a
htmlDependency, for example the shiny bootstrap one (the default)
or a tagList with diferent dependencies}
}
\value{
A UI definition that can be passed to the [shinyUI] function.
}
\description{
Create a page a with CSS grid layout
}
\note{
See
  \url{https://css-tricks.com/snippets/css/complete-guide-grid/}
  for additional details on using css grids
}
\examples{
if (interactive()) {
library(imola)
gridPage(
  title = "A grid page",
  areas = c("area-1 area-1", "area-2 area-3"),
  div(class = "area-1"),
  div(class = "area-2"),
  div(class = "area-3")
)
}

}
\seealso{
[gridPanel()]

Other grid functions: 
\code{\link{gridPanel}()}
}
\concept{grid functions}
