% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmers.R
\name{split_to_kmers}
\alias{split_to_kmers}
\alias{kmer_profile}
\title{Analysis immune repertoire kmer statistics: sequence profiles, etc.}
\usage{
split_to_kmers(.data, .k)

kmer_profile(.data, .method = c("freq", "prob", "wei", "self"), .remove.stop = TRUE)
}
\arguments{
\item{.data}{Character vector or the output from \code{getKmers}.}

\item{.k}{Integer. Size of k-mers.}

\item{.method}{Character vector of length one. If "freq" then returns a position frequency matrix (PFM) -
a matrix with occurences of each amino acid in each position.

If "prob" then returns a position probability matrix (PPM) - a matrix with probabilities of occurences of
each amino acid in each position. This is a traditional representation of sequence motifs.

If "wei" then returns a position weight matrix (PWM) - a matrix with log likelihoods of PPM elements.

If "self" then returns a matrix with self-information of elements in PWM.

For more information see https://en.wikipedia.org/wiki/Position_weight_matrix.}

\item{.remove.stop}{Logical. If TRUE (by default) remove stop codons.}
}
\value{
\code{split_to_kmers} - Data frame with two columns (k-mers and their counts).

\code{kmer_profile} - a matrix with per-position amino acid statistics.
}
\description{
Analysis immune repertoire kmer statistics: sequence profiles, etc.
}
\examples{
data(immdata)
kmers <- getKmers(immdata$data[[1]], 5)
kmer_profile(kmers) \%>\% vis()
}
\concept{k-mers}
