% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_functions.R
\name{imf_data}
\alias{imf_data}
\title{Download a data from the IMF}
\usage{
imf_data(database_id, indicator, country = "all", start = 2000,
  end = current_year(), freq = "A", return_raw = FALSE,
  print_url = FALSE, times = 3)
}
\arguments{
\item{database_id}{character string database ID. Can be found using
\code{\link{imf_ids}}.}

\item{indicator}{character string or character vector of indicator IDs.
These can be found using \code{\link{imf_codes}}.}

\item{country}{character string or character vector of ISO two letter
country codes identifying the countries for which you would like to
download the data.See \url{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}.
If \code{country = 'all'} then \code{imf_data} will attempt to download
all available countries.}

\item{start}{year for which you would like to start gathering the data.}

\item{end}{year for which you would like to end gathering the data.}

\item{freq}{character string indicating the series frequency. With
\code{'A'} for annual, \code{'Q'} for quarterly, and \code{'M'} for monthly.}

\item{return_raw}{logical. Whether to return the data
as an unprocessed list.}

\item{print_url}{logical. Whether to print the URL used in the API call.
Can be useful for debugging.}

\item{times}{numeric. Maximum number of requests to attempt.}
}
\value{
If \code{return_raw = FALSE} then a data frame with just the
requested data series are returned. If \code{return_raw = TRUE} then the raw
data list is returned. This can include additional information about the
series.
}
\description{
Download a data from the IMF
}
\examples{
# Download Real Effective Exchange Rate (CPI base) for the UK and China
# at an annual frequency
real_ex <- imf_data(database_id = 'IFS', indicator = 'EREER_IX',
               country = c('CN', 'GB'), freq = 'A')

\dontrun{
# Also download Interest Rates, Lending Rate, Percent per annum
ex_interest <- imf_data(database_id = 'IFS',
                         indicator = c('FILR_PA', 'EREER_IX'),
                         freq = 'M')
}
}
