% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{resize}
\alias{resize}
\title{Resize image}
\usage{
resize(
  im,
  size_x = -100L,
  size_y = -100L,
  size_z = -100L,
  size_c = -100L,
  interpolation_type = 1L,
  boundary_conditions = 0L,
  centering_x = 0,
  centering_y = 0,
  centering_z = 0,
  centering_c = 0
)
}
\arguments{
\item{im}{an image}

\item{size_x}{Number of columns (new size along the X-axis).}

\item{size_y}{Number of rows (new size along the Y-axis).}

\item{size_z}{Number of slices (new size along the Z-axis).}

\item{size_c}{Number of vector-channels (new size along the C-axis).}

\item{interpolation_type}{Method of interpolation:
-1 = no interpolation: raw memory resizing.
0 = no interpolation: additional space is filled according to  boundary_conditions.
1 = nearest-neighbor interpolation.
2 = moving average interpolation.
3 = linear interpolation.
4 = grid interpolation.
5 = cubic interpolation.
6 = lanczos interpolation.}

\item{boundary_conditions}{Border condition type.}

\item{centering_x}{Set centering type (only if  interpolation_type=0).}

\item{centering_y}{Set centering type (only if  interpolation_type=0).}

\item{centering_z}{Set centering type (only if  interpolation_type=0).}

\item{centering_c}{Set centering type (only if  interpolation_type=0).}
}
\description{
If the dimension arguments are negative, they are interpreted as a proportion of the original image.
}
\seealso{
See imresize for an easier interface.
}
