% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive.R
\name{interact}
\alias{interact}
\title{Build simple interactive interfaces using imager}
\usage{
interact(fun, title = "", init)
}
\arguments{
\item{fun}{a function that takes a single argument (a list of user events) and returns an image to be plotted. The image won't be rescaled before plotting, so make sure RGB values are in [0,1].}

\item{title}{a title for the window (default "", none)}

\item{init}{initial image to display (optional)}
}
\value{
an image, specifically the last image displayed
}
\description{
To explore the effect of certain image manipulations, filter settings, etc., it's useful to have a basic interaction mechanism. You can use shiny for that, but imager provides a lightweight alternative. The user writes a function that gets called every time a user event happens (a click, a keypress, etc.). The role of the function is to process the event and output an image, which will then be displayed.
You can exit the interface at any time by pressing Esc.
See examples for more.
This feature is experimental!!!
Note that you need X11 library to use this function.
}
\examples{
#Implement a basic image gallery:
#press "right" and "left" to view each image in a list
gallery <- function(iml)
{
    ind <- 1
    f <- function(state)
   {
        if (state$key=="arrowleft")
        {
            ind <<- max(ind-1,1)
        }
        if (state$key=="arrowright")
        {
            ind <<- min(ind+1,length(iml))
        }
        iml[[ind]]
    }
    interact(f)
}
##Not run (interactive only)
##map_il(1:10,~ isoblur(boats,.)) \%>\% gallery
}
\author{
Simon Barthelme
}
