% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\name{image_detect_faces}
\alias{image_detect_faces}
\title{Detect faces in images using the libfacedetection CNN}
\usage{
image_detect_faces(x)
}
\arguments{
\item{x}{an object of class magick-image with rgb colors. Or an rgb integer array with pixel values in the 0-255 range.}
}
\value{
A list with elements nr and detections.\cr
Element nr indicates the number of faces found. \cr 
The data frame detections indicates the locations of these. This data.frame has columns x, y, width and height 
as well as a columns called confidence. The values of x and y are the top left of the start of the box. This data frame also has the x and y locations of 5 face landmarks (eyes, nose and mouth ends).
}
\description{
Detect faces in images using using a convolutional neural network available from \url{https://github.com/ShiqiYu/libfacedetection}. 
The function can be used to detect faces of minimal size 10x10 pixels.
}
\examples{
library(magick)
path <- system.file(package="image.libfacedetection", "images", "handshake.jpg")
x <- image_read(path)
x
faces <- image_detect_faces(x)
faces
plot(faces, x, border = "red", lwd = 7, col = "white", landmarks = TRUE)


##
## You can also directly pass on the RGB array in BGR format 
## without the need of having magick
##
tensor <- image_data(x, channels = "rgb")
tensor <- as.integer(tensor)
faces  <- image_detect_faces(tensor)
str(faces)
plot(faces, x)
}
