% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso.R
\name{lasso}
\alias{lasso}
\title{Fit a model using a design matrix}
\usage{
lasso(X, y, family = "gaussian", impl = "cpp", lambda.min.ratio = 1e-04,
  nlambda = 100, lambda = NULL, warm = "lambda", ...)
}
\arguments{
\item{X}{matrix of explanatory variables}

\item{y}{vector of objective variable}

\item{family}{family of regression: "gaussian" (default) or "binomial"}

\item{impl}{implementation language of optimization: "cpp" (default) or "r"}

\item{lambda.min.ratio}{ratio of max lambda and min lambda (ignored if lambda is specified)}

\item{nlambda}{the number of lambda (ignored if lambda is specified)}

\item{lambda}{lambda sequence}

\item{warm}{warm start direction: "lambda" (default) or "delta"}

\item{...}{parameters for optimization}
}
\value{
lasso model
\item{beta}{coefficients}
\item{beta_standard}{standardized coefficients}
\item{a0}{intercepts}
\item{lambda}{regularization parameters}
\item{alpha}{alpha defined above}
\item{delta}{delta defined above}
\item{family}{family}
}
\description{
Fit a model using a design matrix
}
\examples{
X <- matrix(c(1,2,3,5,4,7,6,8,9,10), nrow=5, ncol=2)
b <- matrix(c(-1,1), nrow=2, ncol=1)
e <- matrix(c(0,-0.1,0.1,-0.1,0.1), nrow=5, ncol=1)
y <- as.numeric(X \%*\% b + e)
fit <- lasso(X, y)
pr <- predict_lasso(fit, X)
plot_lasso(fit)
}
