% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan.R
\name{scan_stat}
\alias{scan_stat}
\title{Scan statistics on a time series of graphs}
\usage{
scan_stat(graphs, tau = 1, ell = 0, locality = c("us", "them"), ...)
}
\arguments{
\item{graphs}{A list of igraph graph objects. They must be all directed
or all undirected and they must have the same number of vertices.}

\item{tau}{The number of previous time steps to consider for the
time-dependent normalization for individual vertices.  In other words,
the current locality statistics of each vertex will be compared to this
many previous time steps of the same vertex to decide whether it is
significantly larger.}

\item{ell}{The number of previous time steps to consider
for the aggregated scan statistics. This is essentially a smoothing
parameter.}

\item{locality}{Whether to calculate the \sQuote{us} or \sQuote{them}
statistics.}

\item{...}{Extra arguments are passed to \code{\link[=local_scan]{local_scan()}}.}
}
\value{
A list with entries:
\item{stat}{The scan statistics in each time step. It is \code{NA}
for the initial \code{tau + ell} time steps.}
\item{arg_max_v}{The (numeric) vertex ids for the vertex with
the largest locality statistics, at each time step. It is \code{NA}
for the initial \code{tau + ell} time steps.}
}
\description{
Calculate scan statistics on a time series of graphs.
This is done by calculating the local scan statistics for
each graph and each vertex, and then normalizing across the
vertices and across the time steps.
}
\examples{
## Generate a bunch of SBMs, with the last one being different
num_t <- 20
block_sizes <- c(10, 5, 5)
p_ij <- list(p = 0.1, h = 0.9, q = 0.9)

P0 <- matrix(p_ij$p, 3, 3)
P0[2, 2] <- p_ij$h
PA <- P0
PA[3, 3] <- p_ij$q
num_v <- sum(block_sizes)

tsg <- replicate(num_t - 1, P0, simplify = FALSE) \%>\%
  append(list(PA)) \%>\%
  lapply(sample_sbm, n = num_v, block.sizes = block_sizes, directed = TRUE)

scan_stat(graphs = tsg, k = 1, tau = 4, ell = 2)
scan_stat(graphs = tsg, locality = "them", k = 1, tau = 4, ell = 2)
}
\seealso{
Other scan statistics: 
\code{\link{local_scan}()}
}
\concept{scan statistics}
