% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow.R
\name{edge_connectivity}
\alias{edge_connectivity}
\alias{edge.connectivity}
\alias{edge_disjoint_paths}
\alias{graph.adhesion}
\alias{adhesion}
\alias{edge.disjoint.paths}
\title{Edge connectivity.}
\usage{
edge_connectivity(graph, source = NULL, target = NULL, checks = TRUE)
}
\arguments{
\item{graph}{The input graph.}

\item{source}{The id of the source vertex, for \code{edge_connectivity()} it
can be \code{NULL}, see details below.}

\item{target}{The id of the target vertex, for \code{edge_connectivity()} it
can be \code{NULL}, see details below.}

\item{checks}{Logical constant. Whether to check that the graph is connected
and also the degree of the vertices. If the graph is not (strongly)
connected then the connectivity is obviously zero. Otherwise if the minimum
degree is one then the edge connectivity is also one. It is a good idea to
perform these checks, as they can be done quickly compared to the
connectivity calculation itself.  They were suggested by Peter McMahan,
thanks Peter.}
}
\value{
A scalar real value.
}
\description{
The edge connectivity of a graph or two vertices, this is recently also
called group adhesion.
}
\details{
The edge connectivity of a pair of vertices (\code{source} and
\code{target}) is the minimum number of edges needed to remove to eliminate
all (directed) paths from \code{source} to \code{target}.
\code{edge_connectivity()} calculates this quantity if both the \code{source}
and \code{target} arguments are given (and not \code{NULL}).

The edge connectivity of a graph is the minimum of the edge connectivity of
every (ordered) pair of vertices in the graph.  \code{edge_connectivity()}
calculates this quantity if neither the \code{source} nor the \code{target}
arguments are given (ie. they are both \code{NULL}).

A set of edge disjoint paths between two vertices is a set of paths between
them containing no common edges. The maximum number of edge disjoint paths
between two vertices is the same as their edge connectivity.

The adhesion of a graph is the minimum number of edges needed to remove to
obtain a graph which is not strongly connected. This is the same as the edge
connectivity of the graph.

The three functions documented on this page calculate similar properties,
more precisely the most general is \code{edge_connectivity()}, the others are
included only for having more descriptive function names.
}
\examples{

g <- barabasi.game(100, m = 1)
g2 <- barabasi.game(100, m = 5)
edge_connectivity(g, 100, 1)
edge_connectivity(g2, 100, 1)
edge_disjoint_paths(g2, 100, 1)

g <- sample_gnp(50, 5 / 50)
g <- as.directed(g)
g <- induced_subgraph(g, subcomponent(g, 1))
adhesion(g)

}
\references{
Douglas R. White and Frank Harary: The cohesiveness of blocks in
social networks: node connectivity and conditional density, TODO: citation
}
\seealso{
\code{\link[=max_flow]{max_flow()}}, \code{\link[=vertex_connectivity]{vertex_connectivity()}},
\code{\link[=vertex_disjoint_paths]{vertex_disjoint_paths()}}, \code{\link[=cohesion]{cohesion()}}

Other flow: 
\code{\link{dominator_tree}()},
\code{\link{is_min_separator}()},
\code{\link{is_separator}()},
\code{\link{max_flow}()},
\code{\link{min_cut}()},
\code{\link{min_separators}()},
\code{\link{st_cuts}()},
\code{\link{st_min_cuts}()},
\code{\link{vertex_connectivity}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{flow}
\keyword{graphs}
