% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{groups}
\alias{groups}
\alias{groups.default}
\alias{groups.communities}
\title{Groups of a vertex partitioning}
\usage{
groups(x)
}
\arguments{
\item{x}{Some object that represents a grouping of the vertices. See details
below.}
}
\value{
A named list of numeric or character vectors. The names are just
numbers that refer to the groups. The vectors themselves are numeric or
symbolic vertex ids.
}
\description{
Create a list of vertex groups from some graph clustering or community
structure.
}
\details{
Currently two methods are defined for this function. The default method
works on the output of \code{\link{components}}. (In fact it works on any
object that is a list with an entry called \code{membership}.)

The second method works on \code{\link{communities}} objects.
}
\examples{
g <- make_graph("Zachary")
fgc <- cluster_fast_greedy(g)
groups(fgc)

g2 <- make_ring(10) + make_full_graph(5)
groups(components(g2))
}
\seealso{
\code{\link{components}} and the various community finding
functions.
}
