% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{delete_edge_attr}
\alias{delete_edge_attr}
\alias{remove.edge.attribute}
\title{Delete an edge attribute}
\usage{
delete_edge_attr(graph, name)
}
\arguments{
\item{graph}{The graph}

\item{name}{The name of the edge attribute to delete.}
}
\value{
The graph, with the specified edge attribute removed.
}
\description{
Delete an edge attribute
}
\examples{
g <- make_ring(10) \%>\%
  set_edge_attr("name", value = LETTERS[1:10])
edge_attr_names(g)
g2 <- delete_edge_attr(g, "name")
edge_attr_names(g2)
}
\seealso{
Other graph attributes: \code{\link{delete_graph_attr}},
  \code{\link{delete_vertex_attr}},
  \code{\link{edge_attr<-}}, \code{\link{edge_attr_names}},
  \code{\link{edge_attr}}, \code{\link{graph_attr<-}},
  \code{\link{graph_attr_names}}, \code{\link{graph_attr}},
  \code{\link{igraph-dollar}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{set_edge_attr}},
  \code{\link{set_graph_attr}},
  \code{\link{set_vertex_attr}},
  \code{\link{vertex_attr<-}},
  \code{\link{vertex_attr_names}},
  \code{\link{vertex_attr}}
}
\concept{graph attributes}
