% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{as_long_data_frame}
\alias{as_long_data_frame}
\title{Convert a graph to a long data frame}
\usage{
as_long_data_frame(graph)
}
\arguments{
\item{graph}{Input graph}
}
\value{
A long data frame.
}
\description{
A long data frame contains all metadata about both the vertices
and edges of the graph. It contains one row for each edge, and
all metadata about that edge and its incident vertices are included
in that row. The names of the columns that contain the metadata
of the incident vertices are prefixed with \code{from_} and \code{to_}.
The first two columns are always named \code{from} and \code{to} and
they contain the numeric ids of the incident vertices. The rows are
listed in the order of numeric vertex ids.
}
\examples{
g <- make_(ring(10),
        with_vertex_(name = letters[1:10], color = "red"),
        with_edge_(weight = 1:10, color = "green")
      )
as_long_data_frame(g)
}
