% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/topology.R
\name{isomorphism_class}
\alias{graph.isoclass}
\alias{graph.isoclass.subgraph}
\alias{isomorphism_class}
\title{Isomorphism class of a graph}
\usage{
isomorphism_class(graph, v)
}
\arguments{
\item{graph}{The input graph.}

\item{v}{Optionally a vertex sequence. If not missing, then an induced
subgraph of the input graph, consisting of this vertices, is used.}
}
\value{
An integer number.
}
\description{
The isomorphism class is a non-negative integer number.
Graphs (with the same number of vertices) having the same isomorphism
class are isomorphic and isomorphic graphs always have the same
isomorphism class. Currently it can handle only graphs with 3 or 4
vertices.
}
\examples{
# create some non-isomorphic graphs
g1 <- graph_from_isomorphism_class(3, 10)
g2 <- graph_from_isomorphism_class(3, 11)
isomorphism_class(g1)
isomorphism_class(g2)
isomorphic(g1, g2)
}
\seealso{
Other graph isomorphism: \code{\link{count_isomorphisms}},
  \code{\link{graph.count.isomorphisms.vf2}};
  \code{\link{count_subgraph_isomorphisms}},
  \code{\link{graph.count.subisomorphisms.vf2}};
  \code{\link{graph.get.isomorphisms.vf2}},
  \code{\link{isomorphisms}};
  \code{\link{graph.get.subisomorphisms.vf2}},
  \code{\link{subgraph_isomorphisms}};
  \code{\link{graph.isocreate}},
  \code{\link{graph_from_isomorphism_class}};
  \code{\link{graph.isomorphic}},
  \code{\link{graph.isomorphic.34}},
  \code{\link{graph.isomorphic.bliss}},
  \code{\link{graph.isomorphic.vf2}},
  \code{\link{is_isomorphic_to}}, \code{\link{isomorphic}};
  \code{\link{graph.subisomorphic.lad}},
  \code{\link{graph.subisomorphic.vf2}},
  \code{\link{is_subgraph_isomorphic_to}},
  \code{\link{subgraph_isomorphic}}
}

