% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_in_circle}
\alias{in_circle}
\alias{layout_in_circle}
\title{Graph layout with vertices on a circle.}
\usage{
layout_in_circle(graph, order = V(graph))

in_circle(...)
}
\arguments{
\item{graph}{The input graph.}

\item{order}{The vertices to place on the circle, in the order of their
desired placement. Vertices that are not included here will be placed at
(0,0).}

\item{...}{Passed to \code{layout_in_circle}.}
}
\value{
A numeric matrix with two columns, and one row for each vertex.
}
\description{
Place vertices on a circle, in the order of their vertex ids.
}
\details{
If you want to order the vertices differently, then permute them using the
\code{\link{permute}} function.
}
\examples{
## Place vertices on a circle, order them according to their
## community
\dontrun{
library(igraphdata)
data(karate)
karate_groups <- cluster_optimal(karate)
coords <- layout_in_circle(karate, order =
          order(membership(karate_groups)))
V(karate)$label <- sub("Actor ", "", V(karate)$name)
V(karate)$label.color <- membership(karate_groups)
V(karate)$shape <- "none"
plot(karate, layout = coords)
}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\seealso{
Other graph layouts: \code{\link{add_layout_}};
  \code{\link{as_bipartite}},
  \code{\link{layout.bipartite}},
  \code{\link{layout_as_bipartite}}; \code{\link{as_star}},
  \code{\link{layout.star}}, \code{\link{layout_as_star}};
  \code{\link{as_tree}}, \code{\link{layout_as_tree}};
  \code{\link{component_wise}}; \code{\link{layout.auto}},
  \code{\link{layout_nicely}}, \code{\link{nicely}};
  \code{\link{layout.davidson.harel}},
  \code{\link{layout_with_dh}}, \code{\link{with_dh}};
  \code{\link{layout.gem}}, \code{\link{layout_with_gem}},
  \code{\link{with_gem}}; \code{\link{layout.graphopt}},
  \code{\link{layout_with_graphopt}},
  \code{\link{with_graphopt}}; \code{\link{layout.grid}},
  \code{\link{layout.grid.3d}},
  \code{\link{layout.grid.3d}},
  \code{\link{layout_on_grid}}, \code{\link{on_grid}};
  \code{\link{layout.mds}}, \code{\link{layout_with_mds}},
  \code{\link{with_mds}}; \code{\link{layout.merge}},
  \code{\link{layout_components}},
  \code{\link{merge_coords}},
  \code{\link{piecewise.layout}},
  \code{\link{piecewise.layout}};
  \code{\link{layout.norm}}, \code{\link{norm_coords}};
  \code{\link{layout.sugiyama}},
  \code{\link{layout_with_sugiyama}},
  \code{\link{with_sugiyama}};
  \code{\link{layout_on_sphere}}, \code{\link{on_sphere}};
  \code{\link{layout_randomly}}, \code{\link{randomly}};
  \code{\link{layout_with_fr}}, \code{\link{with_fr}};
  \code{\link{layout_with_kk}}, \code{\link{with_kk}};
  \code{\link{layout_with_lgl}}, \code{\link{with_lgl}};
  \code{\link{layout}}, \code{\link{layout_}},
  \code{\link{print.igraph_layout_modifier}},
  \code{\link{print.igraph_layout_spec}};
  \code{\link{normalize}}
}
\keyword{graphs}

