% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igr_is_valid.R
\name{igr_is_valid}
\alias{igr_is_valid}
\title{Check if Irish grid references are valid}
\usage{
igr_is_valid(x)
}
\arguments{
\item{x}{A character vector of Irish grid references.}
}
\value{
A logical vector indicating the validity of each Irish grid
reference.
}
\description{
\code{igr_is_valid()} identifies valid Irish grid references.
}
\details{
Valid Irish grid references consist of a letter (other than I) optionally
followed by both an easting and northing. The easting and northing must be of
the same length of between 1 and 5 digits. There may be whitespace between
the letter, easting and northing.
}
\examples{
# A vector of alternating valid and invalid Irish grid references
v <- c("N8090", "D 12 345 88800", "W34", "I30", "W", "A123", "B1234", "")

# Check validity of Irish Grid coordinates
igr_is_valid(v)
}
