% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ig_to_igr.R
\name{ig_to_igr}
\alias{ig_to_igr}
\title{Convert Irish Grid coordinates to Irish grid references}
\usage{
ig_to_igr(x, digits = 3, precision = NULL, sep = "")
}
\arguments{
\item{x}{A matrix containing Irish Grid X and Y coordinates in the first
and second columns respectively.}

\item{digits}{An integer, the number of digits for both easting and northing
in the Irish grid references.
\itemize{
\item \code{0}: equivalent to a precision of 100 km.
\item \code{1}: equivalent to a precision of 10 km.
\item \code{2}: equivalent to a precision of 1 km.
\item \code{3} (the default): equivalent to a precision of 100 m.
\item \code{4}: equivalent to a precision of 10 m.
\item \code{5}: equivalent to a precision of 1 m.
}}

\item{precision}{An integer, the precision of the Irish grid references in
metres: \code{1}, \code{10}, \code{100}, \code{1000}, \code{10000}, or \code{100000}. Overrides \code{digits}.}

\item{sep}{A character string to separate the 100 km grid letter, easting,
and northing.}
}
\value{
A character vector of Irish grid references.
}
\description{
\code{ig_to_igr()} converts valid Irish Grid(EPSG:29903) coordinates to Irish grid
references at the specified precision.
}
\details{
Either \code{digits} or \code{precision} must be specified. \code{precision} overrides
\code{digits}.
}
\examples{
# A matrix of three Irish Grid coordinates
m <- matrix(c(0, 412300, 0, 98700, 456000, 0), byrow = TRUE, ncol = 2)

m

# Convert to Irish grid references
ig_to_igr(m)

# Insert a space between the 100 km grid letter, easting, and northing
ig_to_igr(m, sep = " ")

# Convert into Irish grid references with 4 digit easting and northing (10 m precision)
ig_to_igr(m, digits = 4)

# Convert into Irish grid references with 1 km precision (2 digit easting and northing)
ig_to_igr(m, precision = 1000)
}
