#' Criticality Accidents in USAEC Facilities, 1945-1970 (Trinity Atomic Web Site)
#'
#' A table containing the critical accidents in United States Atomic Energy
#' Commission (USAEC) facilities.
#'
#'
#'
#' @format A data.table data frame with 26 rows and 8 variables:
#' \describe{
#' \item{Date}{Date of the accident}
#' \item{Location}{Location of the accident}
#' \item{Active Material}{Active materials released}
#' \item{Geometry}{Geometric description}
#' \item{Total Fissions}{Total number of fissions}
#' \item{Cause}{Cause of the accident}
#' \item{Physical Damage}{Physical damage from the accident}
#' \item{$ Loss}{Monetary loss in US dollars}
#' }
#'
#'
#' @source
#' Trinity Atomic Web Site: Criticality Accidents in USAEC Facilities, 1945-1970 (from "Operational Accidents and Radiation Exposure Experience Within the United States Atomic Energy Commission, 1943-1970," (WASH 1192), U. S. Government Printing Office, Washington, D.C., 1971.), \emph{Bulletin of the American Meteorological Society}, Vol. 78, No. 2, February 1997, pages 197-208, \url{https://www.abomb1.org/accident/crittabl.html}.
#'
#'
#'
#'
#'
#'
"USAEC_facilities_nuclear_accidents"
#> [1] "USAEC_facilities_nuclear_accidents"
