#' Known Exceptional Tennessee Waters and Outstanding National Resource Waters
#'
#' A table containing the exceptional or outstanding national resource waters
#' in Tennessee.
#'
#'
#'
#' @format A data.table data frame with 3,101 rows and 12 variables:
#' \describe{
#' \item{HUC}{HUC number}
#' \item{Watershed Name}{Name of the watershed}
#' \item{Waterbody}{Name of the waterbody}
#' \item{County}{Name of the Tennessee county}
#' \item{Description}{Description of the waterbody}
#' \item{Basis for Inclusion}{Reason for exceptional water status}
#' \item{From_Lat}{Begin latitude}
#' \item{To_Lat}{End latitude}
#' \item{From_Long}{Begin longitude}
#' \item{To_Long}{End longitude}
#' \item{Inclusion Date}{Date of inclusion}
#' \item{Revision Date}{Date of revision, if any}
#' }
#'
#'
#' @source
#' Tennessee Department of Environment and Conservation (TDEC) Division of Water Resources (DWR), Accessed 19 September 2023, The Known Exceptional Tennessee Waters and Outstanding National Resource Waters. \url{https://archive.vn/FxfqY}. Used the archive.today webpage capture for this URL for CRAN acceptance.
#'
#'
#'
#'
"exceptional_tn_waters"
#> [1] "exceptional_tn_waters"
