% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sat_vapor_pressure.R
\encoding{UTF-8}
\name{sp_volume}
\alias{sp_volume}
\title{Specific Volume}
\usage{
sp_volume(rho)
}
\arguments{
\item{rho}{numeric vector that contains the density}
}
\value{
the specific volume as a numeric vector
}
\description{
This function solves for the specific volume of a substance using only the
substance's density
}
\details{
The equation is expressed as

\deqn{\\nu = \frac{1}{\\rho}}

\describe{
  \item{\emph{\\rho}}{substance density (mass divided by volume) [kg/m^3, slug/ft^3", or lbm/ft^3]}
}
}
\examples{
# Examples

library(iemisc)

rho1 <- density_water(T = 68, units = "Eng", Eng_units = "slug/ft^3")

sp_volume(rho = rho1) # slug/ft^3


rho2 <- density_water(T = 68, units = "Eng", Eng_units = "lbm/ft^3")

sp_volume(rho = rho2) # lbm/ft^3


rho3 <- density_water(T = 20, units = "SI")

sp_volume(rho = rho3) # kg / m^3




}
\references{
WikiEngineer, 27 March 2022, "Water Properties & Definitions", \url{https://web.archive.org/web/20210412034245/http://www.wikiengineer.com/Water-Resources/PropertiesAndDefinitions}. Retrieved thanks to the Internet Archive: Wayback Machine
}
\author{
Irucka Embry
}
