% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engr_survey_batch.R
\encoding{UTF-8}
\name{engr_survey_batch}
\alias{engr_survey_batch}
\title{Conversion of Engineering Survey Measurements to Decimal Degrees (KY and TN) - Batch}
\source{
\enumerate{
   \item Win-Vector Blog. John Mount, June 11, 2018, "R Tip: use isTRUE()", \url{https://win-vector.com/2018/06/11/r-tip-use-istrue/}.
   \item Latitude Longitude Coordinates to State Code in R - Stack Overflow answered by Josh O'Brien on Jan 6 2012 and edited by Josh O'Brien on Jun 18, 2020. See \url{https://stackoverflow.com/questions/8751497/latitude-longitude-coordinates-to-state-code-in-r}.
   \item r - Convert column classes in data.table - Stack Overflow answered by Matt Dowle on Dec 27 2013. See \url{https://stackoverflow.com/questions/7813578/convert-column-classes-in-data-table}.
   \item Excel vlook up function in R for data frame - Stack Overflow answered by Tyler Rinker on Apr 8 2013 and edited by Tyler Rinker on Feb 26 2014. See \url{https://stackoverflow.com/questions/15882743/excel-vlook-up-function-in-r-for-data-frame}.
   \item r - Converting geo coordinates from degree to decimal - Stack Overflow answered by Robbes on Jan 3 2018 and edited by ayaio on Jan 3 2018. See \url{https://stackoverflow.com/questions/14404596/converting-geo-coordinates-from-degree-to-decimal}.
   \item r - How to not run an example using roxygen2? - Stack Overflow answered and edited by samkart on Jul 9 2017. (Also see the additional comments in response to the answer.) See \url{https://stackoverflow.com/questions/12038160/how-to-not-run-an-example-using-roxygen2}.
   \item devtools - Issues in R package after CRAN asked to replace dontrun by donttest - Stack Overflow answered by Hong Ooi on Sep 1 2020. (Also see the additional comments in response to the answer.) See \url{https://stackoverflow.com/questions/63693563/issues-in-r-package-after-cran-asked-to-replace-dontrun-by-donttest}.
}
}
\usage{
engr_survey_batch(
  Northing,
  Easting,
  units = c("survey_ft", "foot", "meters"),
  location = c("KY", "TN"),
  output = c("basic", "table")
)
}
\arguments{
\item{Northing}{numeric vector (or character vector with numbers, commas,
and decimal points) that contains the Northing engineering survey
measurement in meters, international foot, or US survey foot [a minimum
of 2 points each time]}

\item{Easting}{numeric vector (or character vector with numbers, commas,
and decimal points) that contains the Easting engineering survey
measurement in meters, international foot, or US survey foot [a minimum
of 2 points each time]}

\item{units}{character vector that contains the system of units (options are
\code{survey_ft} (United States Customary System) [US survey foot],
\code{foot}, or \code{meters} (International System of Units) [meters]
{only 1 set of units at a time}}

\item{location}{character vector that contains the location name ('KY' for
Kentucky or 'TN' for Tennessee) {only 1 location at a time}}

\item{output}{character vector that contains basic for the default result
using a simple \code{\link[data.table]{data.table}} or table for the result as a
complex \code{\link[data.table]{data.table}} [using rbindlist therefore resulting in only
1 data.table]}
}
\value{
the projected associated latitude {Y} and longitude {X} coordinates
  in Decimal Degrees using the \code{\link{sf}} system
}
\description{
Takes Kentucky or Tennessee-based Northing and Easting engineering survey
measurements [based in the State Plane Coordinate System (SPCS)] in meters,
international foot, or US survey foot and converts those values into
geodetic coordinates of the World Geodetic System (WGS) (19)84 (EPSG:4326).
[MapTiler Reference] Each latitude {Y} and longitude {X} point is verified to be
located within Kentucky or Tennessee. This is the batch version of engr_survey
as it processes multiple pairs of Northing and Easting points at a time.
}
\note{
Please Note: If you have Kentucky North/South Zone survey measurements, then
please use the Kentucky Geological Survey, University of Kentucky - Kentucky
Single Coordinate Conversion Tool
(http://kgs.uky.edu/kgsweb/CoordConversionTool.asp) instead. That tool will
give you the geographic coordinates too. This R function, \code{engr_survey_batch}
will only be valid for NAD83 / Kentucky Single Zone.

Useful Tennessee reference Web site
Tennessee Department of Transportation Roadway Design Survey Standards
\url{https://www.tn.gov/tdot/roadway-design/survey-standards.html}

Useful Kentucky reference Web site
Kentucky Transportation Cabinet Survey Coordination
\url{https://transportation.ky.gov/Highway-Design/Pages/Survey-Coordination.aspx}
}
\examples{

# Please refer to the iemisc: Engineering Survey Examples vignette for
# additional examples

# Example 1

# Tennessee (TN) Northing and Easting in US Survey foot

library(iemisc)

Northing1 <- c("630817.6396", "502170.6065", "562,312.2349", "574,370.7178")

Easting1 <- c("2559599.9201", "1433851.6509", "1,843,018.4099", "1,854,896.0041")

dt1 <- engr_survey_batch(Northing1, Easting1, "survey_ft", "TN", output = "basic")




\donttest{
# See Source 6 and Source 7

# Please see the error messages

library(iemisc)

Northing1 <- c("630817.6396", "502170.6065", "562,312.2349", "574,370.7178")

Easting1 <- c("2559599.9201", "1433851.6509", "1,843,018.4099", "1,854,896.0041")

Northing2 <- c(232489.480, 234732.431)

Easting2 <- c(942754.124, 903795.239)


dt1A <- try(engr_survey_batch(Northing1[1], Easting1[1], "survey_ft", "TN",
output = "basic"))
dt1A # first set of Northing, Easting points

dt1B <- try(engr_survey_batch(Northing1[2], Easting1[2], "survey_ft", "TN",
output = "basic"))
dt1B # second set of Northing, Easting points

dt1C <- try(engr_survey_batch(Northing1[3], Easting1[3], "survey_ft", "TN",
output = "basic"))
dt1C # third set of Northing, Easting points

dt1D <- try(engr_survey_batch(Northing1[4], Easting1[4], "survey_ft", "TN",
output = "basic"))
dt1D # fourth set of Northing, Easting points


dt4A <- try(engr_survey_batch(Northing2[1], Easting2[1], "meters", "TN",
output = "table"))
dt4A

dt4B <- try(engr_survey_batch(Northing2[2], Easting2[2], "meters", "TN",
output = "table"))
dt4B
}





}
\references{
\enumerate{
   \item udunits.dat, v 1.18 2006/09/20 18:59:18 steve Exp, \url{https://web.archive.org/web/20230202155021/https://www.unidata.ucar.edu/software/udunits/udunits-1/udunits.txt}. Retrieved thanks to the Internet Archive: Wayback Machine
   \item Spatial Reference, Aug. 13, 2004, "EPSG:3088: NAD83 / Kentucky Single Zone", \url{https://spatialreference.org/ref/epsg/3088/}.
   \item Spatial Reference, March 7, 2000, "EPSG:32136 NAD83 / Tennessee", \url{https://spatialreference.org/ref/epsg/32136/}.
   \item MapTiler Team, "EPSG:4326: WGS 84 -- WGS84 - World Geodetic System 1984, used in GPS, \url{https://epsg.io/4326}.
   \item Tennessee Department of Transportation Design Division, Tennessee Department of Transportation Tennessee Geodetic Reference Network (TGRN) Reference Manual Second Edition Issued, page ix, \url{https://www.tn.gov/content/dam/tn/tdot/documents/TgrnComposite.pdf}.
   \item Earth Point, "State Plane Coordinate System - Convert, View on Google Earth", \url{https://www.earthpoint.us/StatePlane.aspx}.
   \item National Geodetic Survey datasheet95, version 8.12.5.3, online retrieval date July 25, 2019, Mid Valley Oil Rad Relay Twr designation, HA1363 PID, Grayson County Kentucky, Clarkson (1967) USGS Quad, \url{https://www.ngs.noaa.gov/cgi-bin/ds_mark.prl?PidBox=HA1363}.
   \item National Geodetic Survey datasheet95, version 8.12.5.3, online retrieval date July 25, 2019, 2006 42 07 designation, DL4005 PID, Fayette County Kentucky, Lexington West (1993) USGS Quad, \url{https://www.ngs.noaa.gov/cgi-bin/ds_mark.prl?PidBox=DL4005}.
}
}
\author{
Irucka Embry
}
