% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engr_survey.R
\encoding{UTF-8}
\name{engr_survey}
\alias{engr_survey}
\title{Conversion of Engineering Survey Measurements to Decimal Degrees (KY and TN)}
\source{
\enumerate{
   \item Win-Vector Blog. John Mount, June 11, 2018, "R Tip: use isTRUE()", \url{https://win-vector.com/2018/06/11/r-tip-use-istrue/}.
   \item Latitude Longitude Coordinates to State Code in R - Stack Overflow answered by Josh O'Brien on Jan 6 2012 and edited by Josh O'Brien on Jun 18, 2020. See \url{https://stackoverflow.com/questions/8751497/latitude-longitude-coordinates-to-state-code-in-r}.
   \item r - Convert column classes in data.table - Stack Overflow answered by Matt Dowle on Dec 27 2013. See \url{https://stackoverflow.com/questions/7813578/convert-column-classes-in-data-table}.
   \item Excel vlook up function in R for data frame - Stack Overflow answered by Tyler Rinker on Apr 8 2013 and edited by Tyler Rinker on Feb 26 2014. See \url{https://stackoverflow.com/questions/15882743/excel-vlook-up-function-in-r-for-data-frame}.
   \item r - Converting geo coordinates from degree to decimal - Stack Overflow answered by Robbes on Jan 3 2018 and edited by ayaio on Jan 3 2018. See \url{https://stackoverflow.com/questions/14404596/converting-geo-coordinates-from-degree-to-decimal}.
   \item r - How to not run an example using roxygen2? - Stack Overflow answered and edited by samkart on Jul 9 2017. (Also see the additional comments in response to the answer.) See \url{https://stackoverflow.com/questions/12038160/how-to-not-run-an-example-using-roxygen2}.
   \item devtools - Issues in R package after CRAN asked to replace dontrun by donttest - Stack Overflow answered by Hong Ooi on Sep 1 2020. (Also see the additional comments in response to the answer.) See \url{https://stackoverflow.com/questions/63693563/issues-in-r-package-after-cran-asked-to-replace-dontrun-by-donttest}.
}
}
\usage{
engr_survey(
  Northing,
  Easting,
  units = c("survey_ft", "foot", "meters"),
  location = c("KY", "TN"),
  output = c("basic", "table"),
  utm = c(0, 1)
)
}
\arguments{
\item{Northing}{numeric vector (or character vector with numbers, commas,
and decimal points) that contains the Northing engineering survey
measurement in meters, international foot, or US survey foot}

\item{Easting}{numeric vector (or character vector with numbers, commas,
and decimal points) that contains the Easting engineering survey
measurement in meters, international foot, or US survey foot}

\item{units}{character vector that contains the system of units (options are
\code{survey_ft} (United States Customary System) [US survey foot],
\code{foot}, or \code{meters} (International System of Units) [meters]}

\item{location}{character vector that contains the location name ('KY' for
Kentucky or 'TN' for Tennessee)}

\item{output}{character vector that contains basic for the default result
using a simple \code{\link[data.table]{data.table}} or table for the result as a
complex \code{\link[data.table]{data.table}}}

\item{utm}{numeric vector that contains 0 or 1 only. 0 represents do not
provide the utm coordinates and 1 is to provide the utm coordinates}
}
\value{
the projected associated latitude {Y} and longitude {X} coordinates in Decimal Degrees as a \code{\link[data.table]{data.table}} or as an enhanced
  \code{\link[data.table]{data.table}} with the Northing and Easting coordinates in US
  survey foot, foot, and meters in addition to the {Y} and {X} coordinates
  for the begin, middle, and end points
}
\description{
Takes Kentucky or Tennessee-based Northing and Easting engineering survey
measurements [based in the State Plane Coordinate System (SPCS)] in meters,
international foot, or US survey foot and converts those values into
geodetic coordinates of the World Geodetic System (WGS) (19)84 (EPSG:4326).
[MapTiler Reference] Each latitude {Y} and longitude {X} point is verified to be
located within Kentucky or Tennessee.
}
\note{
Please Note: If you have Kentucky North/South Zone survey measurements, then
please use the Kentucky Geological Survey, University of Kentucky - Kentucky
Single Coordinate Conversion Tool
(http://kgs.uky.edu/kgsweb/CoordConversionTool.asp) instead. That tool will
give you the geographic coordinates too. This R function, engr_survey will
only be valid for NAD83 / Kentucky Single Zone.

Useful Tennessee reference Web site
Tennessee Department of Transportation Roadway Design Survey Standards
\url{https://www.tn.gov/tdot/roadway-design/survey-standards.html}

Useful Kentucky reference Web site
Kentucky Transportation Cabinet Survey Coordination
\url{https://transportation.ky.gov/Highway-Design/Pages/Survey-Coordination.aspx}
}
\examples{

# Please refer to the iemisc: Engineering Survey Examples vignette for
# additional examples

# Test 1 against TGRN Manual (Reference 5)
# using the 1983 (1995) DATUM
# GPS 1 is the station name with these coordinates
# latitude (North) = 36 22 6.43923
# longitude (West) = 82 10 46.87679

library(iemisc)

Northing_test1 <- 232489.480 # provided in TGRN Manual
Easting_test1 <- 942754.124 # provided in TGRN Manual

tgrn1 <- engr_survey(Northing_test1, Easting_test1, "meters", "TN", output =
"table", utm = 0)
tgrn1



# Test 2 against TGRN Manual (Reference 5)
# using the 1983 (1995) DATUM
# GPS 60 is the station name with these coordinates
# latitude (North) = 35 8 46.44496
# longitude (West) = 89 54 24.04763

library(iemisc)

Northing_test2 <- 97296.815 # provided in TGRN Manual
Easting_test2 <- 244089.427 # provided in TGRN Manual

tgrn2 <- engr_survey(Northing_test2, Easting_test2, "meters", "TN", output =
"table", utm = 0)
tgrn2



# Test 3 against the NGS Data sheet (Reference 7)
# using the NAD 83(1993) DATUM
# with these adjusted coordinates
# latitude (North) = 37 24 17.73330
# longitude (West) = 086 14 14.18027

library(iemisc)

# The following coordinates were computed from the latitude / longitude
# using NAD 83(1993)
Northing_test3 <- "1,119,041.443" # provided in NGS Data sheet
Easting_test3 <- "1,456,861.006" # provided in NGS Data sheet

ky1 <- engr_survey(Northing_test3, Easting_test3, "meters", "KY", output =
"table", utm = 0)
ky1



# Test 4 against the NGS Data sheet (Reference 8)
# using the NAD 83(2011) DATUM
# with these no check coordinates
# latitude (North) = 38 04 23.86331
# longitude (West) = 084 32 04.55607

library(iemisc)

# The following coordinates were computed from the latitude / longitude
# using NAD 83(2011)
Northing_test4 <- "3,671,388.47" # provided in NGS Data sheet
Easting_test4 <- "4,779,718.15" # provided in NGS Data sheet

ky2 <- engr_survey(Northing_test4, Easting_test4, "survey_ft", "KY", output =
"table", utm = 0)
ky2




# Example 1
# Kentucky (KY) Northing and Easting in US Survey foot

library(iemisc)

Northing1 <- 3807594.80077

Easting1 <- 5625162.88913

dt1 <- engr_survey(Northing = Northing1, Easting = Easting1, units =
"survey_ft", location = "KY", output = "table", utm = 1)
dt1



# Example 2
# Kentucky (KY) Northing and Easting in meters

library(iemisc)

Northing2 <- 1170338.983

Easting2 <- 1624669.125

dt2 <- engr_survey(Northing2, Easting2, "meters", "KY", output = "basic",
utm = 0)
dt2



\donttest{
# See Source 6 and Source 7

# Please see the error messages

library(iemisc)

# Tennessee (TN) Northing and Easting in US Survey foot
Northing3 <- c("630817.6396", "502170.6065", "562,312.2349", "574,370.7178")

Easting3 <- c("2559599.9201", "1433851.6509", "1,843,018.4099", "1,854,896.0041")


dt3 <- try(engr_survey(Northing3, Easting3, "survey_ft", "TN", output = "basic",
utm = 0))


Northing4 <- c(232489.480, 234732.431)

Easting4 <- c(942754.124, 903795.239)

dt4 <- try(engr_survey(Northing4, Easting4, "survey_ft", "TN", output =
"basic", utm = 0))
}




}
\references{
\enumerate{
   \item udunits.dat, v 1.18 2006/09/20 18:59:18 steve Exp, \url{https://web.archive.org/web/20230202155021/https://www.unidata.ucar.edu/software/udunits/udunits-1/udunits.txt}. Retrieved thanks to the Internet Archive: Wayback Machine
   \item Spatial Reference, Aug. 13, 2004, "EPSG:3088: NAD83 / Kentucky Single Zone", \url{https://spatialreference.org/ref/epsg/3088/}.
   \item Spatial Reference, March 7, 2000, "EPSG:32136 NAD83 / Tennessee", \url{https://spatialreference.org/ref/epsg/32136/}.
   \item MapTiler Team, "EPSG:4326: WGS 84 -- WGS84 - World Geodetic System 1984, used in GPS, \url{https://epsg.io/4326}.
   \item Tennessee Department of Transportation Design Division, Tennessee Department of Transportation Tennessee Geodetic Reference Network (TGRN) Reference Manual Second Edition Issued, page ix, \url{https://www.tn.gov/content/dam/tn/tdot/documents/TgrnComposite.pdf}.
   \item Earth Point, "State Plane Coordinate System - Convert, View on Google Earth", \url{https://www.earthpoint.us/StatePlane.aspx}.
   \item National Geodetic Survey datasheet95, version 8.12.5.3, online retrieval date July 25, 2019, Mid Valley Oil Rad Relay Twr designation, HA1363 PID, Grayson County Kentucky, Clarkson (1967) USGS Quad, \url{https://www.ngs.noaa.gov/cgi-bin/ds_mark.prl?PidBox=HA1363}.
   \item National Geodetic Survey datasheet95, version 8.12.5.3, online retrieval date July 25, 2019, 2006 42 07 designation, DL4005 PID, Fayette County Kentucky, Lexington West (1993) USGS Quad, \url{https://www.ngs.noaa.gov/cgi-bin/ds_mark.prl?PidBox=DL4005}.
}
}
\author{
Irucka Embry
}
