% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edf.R
\name{read_edf}
\alias{read_edf}
\title{Read 'EDF' or 'BDF' data file}
\usage{
read_edf(
  con,
  extract_path = getOption("ieegio.extract_path", NULL),
  header_only = FALSE,
  cache_ok = TRUE,
  begin = 0,
  end = Inf,
  convert = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{con}{file or connection to the data file}

\item{extract_path}{location to where the extracted information is to be
stored}

\item{header_only}{whether to only load header data}

\item{cache_ok}{whether existing cache should be reused; default is
\code{TRUE}. This input can speed up reading large data files; set to
\code{FALSE} to delete cache before importing.}

\item{begin, end}{begin and end of the data to read}

\item{convert}{whether to convert digital numbers to analog signals; default
is \code{TRUE}}

\item{verbose}{whether to print processing messages; default is \code{TRUE}}
}
\value{
A cached object that is readily to be loaded to memory; see
\code{\link{SignalDataCache}} for class definition.
}
\description{
Read 'EDF' or 'BDF' data file
}
\examples{

# ---- EDF/BDF(+) ---------------------------------------------------------

# Run `ieegio_sample_data("edfPlusD.edf")` to download sample data

# Tun example if the sample data exists
if(ieegio_sample_data("edfPlusD.edf", test = TRUE)) {

  edf_path <- ieegio_sample_data("edfPlusD.edf")

  data <- read_edf(edf_path)

  data$get_header()

  data$get_annotations()

  data$get_channel_table()

  channel <- data$get_channel(1)

  plot(
    channel$time,
    channel$value,
    type = "l",
    main = channel$info$Label,
    xlab = "Time",
    ylab = channel$info$Unit
  )

}


}
