% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/euclidean_distance.R
\name{euclidean_distance}
\alias{euclidean_distance}
\title{Euclidean Distance (\code{euclidean_distance})}
\usage{
euclidean_distance(
  ego_id,
  ego_measure,
  alter_ego,
  alter_measure,
  prefix = NULL,
  suffix = NULL
)
}
\arguments{
\item{ego_id}{A vector of unique ego identifiers located in an ego dataframe. If using data objects created by \code{\link{ego_netwrite}}, this should be the data frame entitled \code{egos}.}

\item{ego_measure}{A vector of attributes corresponding to each ego.}

\item{alter_ego}{A vector of ego identifiers located in an alter dataframe. If using data objects created by \code{\link{ego_netwrite}}, this should be the data frame entitled \code{alters}.}

\item{alter_measure}{A vector of attributes corresponding to each alter.}

\item{prefix}{A character value indicating the desired prefix for the calculated homophily measure.}

\item{suffix}{A character value indicating the desired suffix for the calculated homophily measure.}
}
\value{
\code{euclidean_distance} returns a dataframe of vectors that include the ego identifier and euclidean distance for the desired continuous attribute
}
\description{
Typical difference between between ego and their alters for a given continuous attribute (Perry et al. 2018)
}
\examples{

# Run `ego_netwrite`
ngq_nw <- ego_netwrite(egos = ngq_egos,
                      ego_id = ngq_egos$ego_id,

                      alters = ngq_alters,
                      alter_id = ngq_alters$alter_id,
                      alter_ego = ngq_alters$ego_id,

                      max_alters = 10,
                      alter_alter = ngq_aa,
                      aa_ego = ngq_aa$ego_id,
                      i_elements = ngq_aa$alter1,
                      j_elements = ngq_aa$alter2,
                      directed = FALSE)


# Calculate Euclidean Distance
pol_euc <- euclidean_distance(ego_id = ngq_nw$egos$ego_id, ego_measure = ngq_nw$egos$pol,
                             alter_ego = ngq_nw$alters$ego_id, alter_measure = ngq_nw$alters$pol,
                             prefix = "pol")
pol_euc
}
