% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-rgl-grid.R, R/plot-rgl-facelayer.R
\docType{data}
\name{plot3d}
\alias{plot3d}
\alias{plot3d.trigrid}
\alias{plot3d.hexagrid}
\alias{plot3d.facelayer}
\title{3d plotting of an icosahedral grid, its subset or a data layer}
\format{
An object of class \code{function} of length 1.
}
\usage{
plot3d(x,...)

\method{plot3d}{trigrid}(x, type = c("l"), sphere = NULL, add = FALSE, guides = TRUE, ...)

\method{plot3d}{hexagrid}(
  x,
  type = c("l"),
  sphere = NULL,
  color = "gray70",
  add = FALSE,
  guides = TRUE,
  ...
)

\method{plot3d}{facelayer}(x, type = "f", frame = TRUE, guides = TRUE, defaultPar3d = TRUE, ...)
}
\arguments{
\item{x}{(\code{\link{trigrid}}, \code{\link{hexagrid}} or \code{\link{facelayer}}) Object to be plotted.}

\item{type}{(\code{character}) Value specifying the part of the grid to be plotted by the call of the function. 
\code{"v"} plots the grid vertex points. 
\code{"e"} draws the grid edges.
\code{"f"} draws the grid faces.
\code{"c"} draws the face centers of the grid.}

\item{sphere}{(\code{numeric}) Defaults to \code{NULL}, adding a central white sphere to the plot. Assigning a \code{numeric} value will draw a new sphere with the given radius,
\code{FALSE} does not plot the sphere.}

\item{add}{(\code{logical}) Value indicating whether a new plot shall be drawn, or the currently plotted information should be added to the active \code{rgl} device.}

\item{guides}{(\code{logical}) Value indicating whether the guidelines of the polar coordinate system shall be plotted.}

\item{...}{Further graphical parameters passed to (see \code{\link[rgl]{plot3d}}).}

\item{color}{(\code{character}) Only for the hexagrid plotting: value/values passed to the \code{\link{faces3d}} function instead of \code{col}.}

\item{frame}{(\code{logical}) If set to TRUE the grid line structure will be plotted.}

\item{defaultPar3d}{(\code{logical}) Flag indicating whether the default settings for \code{\link[rgl]{par3d}} are to be used \code{(windowRect = c(50, 60, 800, 800), zoom=0.8)}.}
}
\value{
The function does not return any value.
}
\description{
The function is built on the openGL renderer of the R package \code{rgl}. The default plotting window size is \code{800x800} pixels. In case you want to override this, please
use the function with \code{defaultPar3d=FALSE} after running \code{\link[rgl]{par3d}}\code{(windowRect=<>)}.
}
\examples{
# create a hexagonal grid
    g <- hexagrid(c(2,2))
# plot the grid in 3d space
#   plot3d(g, col="blue")
# make a subset to select faces
   subG <- subset(g, c("F5", "F2"))
# plot the subset defined above
#    plot3d(subG, type="f", col=c("orange"), add=TRUE, lwd=1)
}
\keyword{datasets}
