% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{oanda_get_key}
\alias{oanda_get_key}
\title{Get OANDA fxTrade API Key}
\usage{
oanda_get_key()
}
\value{
A character string, respresenting the key stored in the default
    keyring under the service name 'OANDA_API_KEY' if present, otherwise the
    key supplied by the user interactively.
}
\description{
Return OANDA fxTrade API key (personal access token) stored in the keyring,
    or else prompts the user to provide a key interactively.
}
\details{
For retrieving the key from the keyring, this function has a dependency
    on the 'keyring' package, otherwise it can be used to read a key supplied
    interactively.

    For further details please refer to the OANDA fxTrade API vignette by
    running: \code{vignette("xoanda", package = "ichimoku")}.
}
\examples{
if (interactive()) {
# Only run example in interactive R sessions
oanda_get_key()
}

}
