% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkdir.R
\name{mkdir}
\alias{mkdir}
\title{Create Directory}
\usage{
mkdir(path)
}
\arguments{
\item{path}{a directory name.}
}
\value{
\code{TRUE} for success, \code{FALSE} for failure, invisibly.
}
\description{
Create directory, including parent directories if necessary, without
generating a warning if the directory already exists.
}
\note{
Shorthand for
\code{dir.create(path, showWarnings = FALSE, recursive = TRUE)}.
}
\examples{
\dontrun{
mkdir("emptydir")
unlink("emptydir", recursive=TRUE)

mkdir("outer/inner")
unlink("outer/inner", recursive=TRUE)
}

}
\seealso{
\code{\link{dir.create}} is the base function to create an empty directory.

\code{\link{unlink}} with \code{recursive = TRUE} removes directories.

\code{\link{clean}} cleans TAF directories.

\code{\link{icesTAF-package}} gives an overview of the package.
}
