% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DLS3.2.R
\name{DLS3.2}
\alias{DLS3.2}
\title{DLS Method 3.2}
\usage{
DLS3.2(lastadvice, index, len = c(3, 2), buffer = FALSE, i1, i2)
}
\arguments{
\item{lastadvice}{last catch advice given for this stock.}

\item{index}{stock size index.}

\item{len}{two integers, indicating the desired lengths of reference vectors.}

\item{buffer}{whether to apply a -20\% precautionary buffer.}

\item{i1}{included for backward compatibility, use \code{len} instead.}

\item{i2}{included for backward compatibility, use \code{len} instead.}
}
\value{
A list containing the resulting \code{advice} and other elements showing
intermediate steps in the calculations.
}
\description{
Apply ICES method 3.2 to calculate catch advice for data-limited stocks
(DLS).
}
\details{
This function compares the average values of two reference vectors \code{i1}
and \code{i2}. In the simplest case, only \code{lastadvice} and \code{index}
are required to calculate the advice.

The default value of \code{len = c(3, 2)} produces vectors \code{i1} and
\code{i2} of lengths 3 and 2,

\verb{  }i1 = (I[n-4], I[n-3], I[n-2])

\verb{  }i2 = (I[n-1], I[n])

where I is a stock size index of length n.

Other vector lengths can be used, such as \code{len = c(5, 2)} to get

\verb{  }i1 = (I[n-6], I[n-5], I[n-4], I[n-3], I[n-2])

\verb{  }i2 = (I[n-1], I[n])

Finally, a -20\% precautionary buffer can be applied at the end of all
calculations.

See the ICES (2012) guidance report for details.
}
\examples{
# Three hypothetical surveys
survey <- data.frame(year=2001:2010, randu[1:10,])

DLS3.2(1000, survey$x)

DLS3.2(1000, survey$y)
DLS3.2(1000, survey$y, len=c(5,2))

DLS3.2(1000, survey$z)
DLS3.2(1000, survey$z, buffer=TRUE)

# Plot
output <- DLS3.2(1000, survey$y)
plot(y~year, survey, ylab="index", type="b", lty=3)
segments(2006, output$i1bar, 2008, lwd=2)
segments(2009, output$i2bar, 2010, lwd=2)

}
\references{
ICES (2012) ICES DLS guidance report: ICES implementation of advice for
data-limited stocks in 2012 in its 2012 advice.
\href{http://ices.dk/sites/pub/Publication\%20Reports/Expert\%20Group\%20Report/acom/2012/ADHOC/DLS\%20Guidance\%20Report\%202012.pdf}{\emph{ICES
CM 2012/ACOM:68}}.
}
\seealso{
\code{\link{icesAdvice-package}} gives an overview of the package.
}
\author{
Anne Cooper and Arni Magnusson.
}
