% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{icd9VanWalraven}
\alias{icd9VanWalraven}
\alias{icd9VanWalraven.data.frame}
\alias{icd9VanWalravenComorbid}
\title{Calculate van Walraven Elixhauser Score}
\usage{
icd9VanWalraven(x, visitId = NULL, return.df = FALSE,
  stringsAsFactors = getOption("stringsAsFactors"), ...)

\method{icd9VanWalraven}{data.frame}(x, visitId = NULL, return.df = FALSE,
  stringsAsFactors = getOption("stringsAsFactors"), ...)

icd9VanWalravenComorbid(x, visitId = NULL, applyHierarchy = FALSE)
}
\arguments{
\item{x}{data frame containing a column of visit or patient identifiers, and
a column of ICD-9 codes. It may have other columns which will be ignored.
By default, the first column is the patient identifier and is not counted.
If \code{visitId} is not specified, the first column is used.}

\item{visitId}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. If left empty, or \code{NULL}, then an
attempt is made to guess which field has the ID for the patient encounter
(not a patient ID, although this can of course be specified directly). The
guesses proceed until a single match is made. Data frames may be wide with
many matching fields, so to avoid false positives, anything but a single
match is rejected. If there are no successful guesses, and \code{visitId}
was not specified, then the first column of the data frame is used.}

\item{return.df}{single logical value, if true, a two column data frame will
be returned, with the first column named as in input data frame (i.e.
\code{visitId}), containing all the visits, and the second column
containing the Charlson Comorbidity Index.}

\item{stringsAsFactors}{single logical, passed on when constructing
data.frame if \code{return.df} is \code{TRUE}. If the input data frame
\code{x} has a factor for the visitId, this is not changed, but a
non-factor visitId may be converted or not converted according to your
system default or this setting.}

\item{...}{further arguments to pass on to \code{icd9ComorbidQuanElix}, e.g.
\code{icd9Field}, \code{applyHeirarchy}}

\item{applyHierarchy}{single logical value, default is \code{FALSE}. If
\code{TRUE}, will drop DM if DMcx is present, etc.}
}
\description{
van Walraven Elixhauser score is calculated from the Quan
  revision of Elixhauser's ICD-9 mapping. This function allows for the
  hierarchical exlusion of less severe versions of comorbidities when their
  more severe version is also present via the applyHeirarchy argument. For
  the Elixhauser comorbidities, this is diabetes v. complex diabetes and
  solid tumor v. metastatic tumor
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: van Walraven scores from data frame of visits and ICD-9 codes
}}
\examples{
mydf <- data.frame(visitId = c("a", "b", "c"),
                   icd9 = c("412.93", "441", "044.9"))

print(
  cmb <- icd9ComorbidQuanElix(mydf, isShort = FALSE, applyHierarchy = TRUE, return.df=TRUE)
)
icd9VanWalravenComorbid(cmb)

icd9VanWalraven(mydf)
icd9VanWalraven(mydf, return.df = TRUE)
}
\author{
wmurphyrd
}
\references{
van Walraven C, Austin PC, Jennings A, Quan H, Forster AJ. A
  Modification to the Elixhauser Comorbidity Measures Into a Point System for
  Hospital Death Using Administrative Data. Med Care. 2009; 47(6):626-633.
  \url{http://www.ncbi.nlm.nih.gov/pubmed/19433995}
}

