% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9InReferenceCode}
\alias{"\%i9in\%"}
\alias{\%i9in\%}
\alias{icd9InReferenceCode}
\title{match ICD9 codes}
\usage{
icd9InReferenceCode(icd9, icd9Reference, isShort = TRUE,
  isShortReference = TRUE, invalidAction = icd9InvalidActions,
  invalidActionReference = icd9InvalidActions)

icd9 \%i9in\% icd9Reference
}
\arguments{
\item{"icd9,icd9Reference"}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{isShort}{single logical value which determines whether the ICD-9 code provided is in short (TRUE) or decimal (FALSE) form.}

\item{isShortReference}{logical, see argument \code{isShort}}

\item{"invalidAction,invalidActionReference"}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\value{
logical vector of which icd9 match or are subcategory of
  icd9Referenec
}
\description{
Finds children of ricd9Reference and looks for icd9 in the
  resulting vector.  It is a glorified %in% function.
}
\examples{
"1024" \%i9in\% "102"
"1024" \%i9in\% c("102","1025")
c("102", "1024","1025") \%i9in\% "102"
c("102", "1024","1025") \%i9in\% c("1024", "1025")
c("102", "1024","1025") \%i9in\% c("102", "1024", "1025")
}
\keyword{internal}

