% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadocs.R
\docType{data}
\name{icd10cm2019}
\alias{icd10cm2019}
\title{United States and Belgium ICD-10-CM}
\source{
\url{http://www.cdc.gov/nchs/icd/icd10cm.htm}
}
\description{
The public domain modified ICD-10 classification as published in the public
domain by the US CDC. Currently this has a slightly different structure to
\code{icd9cm_hierarchy} because the published data helpfully has a
\emph{leaf} flag indicating whether a code is a \emph{billable} leaf node, or
a code higher in the hierarchy which nevertheless will have a description.
}
\details{
Format:  data frame, with columns for code, leaf status (0 or 1),
  short and long descriptions.
}
\section{Editions}{
 There are annual revisions to this data in the US.
}

\references{
\url{https://www.cms.gov/Medicare/Coding/ICD10/}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2018-ICD-10-PCS-Tables-And-Index.zip}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2018-ICD-10-PCS-Order-File.zip}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2017-PCS-Code-Tables.zip}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2017-PCS-Long-Abbrev-Titles.zip}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2016-Code-Descriptions-in-Tabular-Order.zip}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2015-code-descriptions.zip}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2015-tables-index.zip}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2015-Code_Tables-and-Index.zip}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2015-PCS-long-and-abbreviated-titles.zip}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2014-ICD10-Code-Descriptions.zip}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2014-ICD10-Code-Tables-and-Index.zip}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2014-Code-Tables-and-Index.zip}
  \url{https://www.cms.gov/Medicare/Coding/ICD10/Downloads/2014-PCS-long-and-abbreviated-titles.zip}
}
\seealso{
\code{\link{get_icd10cm2014}} \code{\link{get_icd10cm2015}}
  \code{\link{get_icd10cm2017}} \code{\link{get_icd10cm2018}}
}
\keyword{datasets}
