% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges.R
\name{expand_range_major}
\alias{expand_range_major}
\alias{expand_range_major.default}
\alias{expand_range_major.icd10cm}
\alias{expand_range_major.icd9}
\title{Expand two major codes to a range}
\usage{
expand_range_major(start, end, defined = TRUE)

\method{expand_range_major}{default}(start, end, defined = TRUE)

\method{expand_range_major}{icd10cm}(start, end, defined = TRUE)

\method{expand_range_major}{icd9}(start, end, defined = TRUE)
}
\arguments{
\item{...}{arguments passed on to other functions}
}
\description{
Expand a pair of major codes into a range of major codes. Primarily for use
by \code{icd.data}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Expand range of top-level, 'major' codes
of unknown type

\item \code{icd10cm}: Expand range of top-level ICD-10 codes

\item \code{icd9}: Expand a range of ICD-9 major codes into
major codes
}}

\examples{
expand_range_major("100", "102")
}
\keyword{internal}
