% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{combine}
\alias{combine}
\alias{c.icd9}
\alias{c.icd10}
\title{Combine ICD codes}
\usage{
\method{c}{icd9}(..., warn = FALSE)

\method{c}{icd10}(..., warn = FALSE)
}
\arguments{
\item{...}{elements to combine}

\item{warn}{single logical value, if \code{TRUE}, will give warnings when
incompatible types are combined using \code{\link[base]{c}}}
}
\description{
These function implement ICD specific methods for \code{c}, i.e.,
combinations of lists or vectors of codes, while preserving ICD classes. Base
\R \code{\link[base]{c}} just drops all user defined classes and casts down
to lowest common denominator, e.g. if mixing numbers and characters. No
attempt here to catch all possible combinations of feeding in mixed ICD types
and other types. Let R do what it normally does, but just try to keep classes
of the first item in the list.
}
\examples{
# Care with the following:
c(as.icd9("E998"), as.icd10("A10"))
# which results in both codes sharing the 'icd9' class.
# ICD-10 codes
(a <- as.icd10("A100SSX"))
(b <- as.icd10("Z999A"))
c(a, b)
c(as.icd_short_diag(a), as.icd_short_diag(b))
(d <- as.icd10("A10.0SSX"))
(e <- as.icd10("Z99.9A"))
c(d, e)
c(as.icd_decimal_diag(d), as.icd_decimal_diag(e))
# warn when mixing attribute types
suppressWarnings(
  c(as.icd_short_diag(a), as.icd_decimal_diag(e))
)
}
\seealso{
\link[=set_icd_class]{ICD data types}
}
