% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R, R/z-deprecated.R
\name{get_valid}
\alias{get_valid}
\alias{get_valid.character}
\alias{get_valid.icd9}
\alias{get_valid.icd10}
\alias{get_valid.icd10cm}
\alias{icd_get_valid}
\title{invalid subset of decimal or short_code ICD-9 codes}
\usage{
get_valid(x, short_code = guess_short(x))

\method{get_valid}{character}(x, short_code = guess_short(x))

\method{get_valid}{icd9}(x, short_code = guess_short(x))

\method{get_valid}{icd10}(x, short_code = guess_short(x))

\method{get_valid}{icd10cm}(x, short_code = guess_short(x))

icd_get_valid(...)
}
\arguments{
\item{x}{input vector of ICD codes}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{...}{arguments passed on to other functions}
}
\description{
Given vector of short_code or decimal ICD-9 codes, return (in the
  same format) those codes which are valid or invalid. Useful for generating
  error messages with the faulty codes if validation fails.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: get valid ICD codes from character vector, guessing ICD version

\item \code{icd9}: Get valid ICD-9 codes

\item \code{icd10}: Get valid ICD-10 codes, currently based on ICD-10-CM
structure, which is a super-set of WHO ICD-10

\item \code{icd10cm}: Get valid ICD-10-CM codes
}}

\section{Deprecated function names}{
 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the prefix \code{icd::} instead, e.g., \code{icd::charlson}.
  Functions which specifically operate on either ICD-9 or ICD-10 codes or
  their sub-types will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.
}

\keyword{internal}
\keyword{manip}
